/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.io.IOException;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.indices.GetDataStreamRequest;
import org.opensearch.client.opensearch.indices.GetDataStreamResponse;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamDetector {
    private static final Logger LOG = LoggerFactory.getLogger(DataStreamDetector.class);
    private final OpenSearchClient openSearchClient;
    private final IndexCache indexCache;

    public DataStreamDetector(OpenSearchClient openSearchClient, IndexCache indexCache) {
        this.openSearchClient = openSearchClient;
        this.indexCache = indexCache;
    }

    public boolean isDataStream(String indexName) {
        Boolean cached = this.indexCache.getDataStreamResult(indexName);
        if (cached != null) {
            return cached;
        }
        boolean result = this.checkDataStream(indexName);
        this.indexCache.putDataStreamResult(indexName, result);
        return result;
    }

    private boolean checkDataStream(String indexName) {
        try {
            GetDataStreamRequest request = GetDataStreamRequest.of(r -> r.name(indexName, new String[0]));
            GetDataStreamResponse response = this.openSearchClient.indices().getDataStream(request);
            return response.dataStreams() != null && !response.dataStreams().isEmpty();
        }
        catch (IOException e) {
            LOG.debug("Index '{}' is not a Data Stream: {}", (Object)indexName, (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOG.debug("Data Stream detection not supported or failed for index '{}': {}", (Object)indexName, (Object)e.getMessage());
            return false;
        }
    }
}

