/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.common.opensearch;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.plugins.sink.opensearch.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.AwsAuthenticationConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.ServerlessOptions;

public class ServerlessOptionsFactory {
    public static Optional<ServerlessOptions> create(ConnectionConfiguration connectionConfiguration) {
        if (!connectionConfiguration.isServerless() || StringUtils.isBlank((CharSequence)connectionConfiguration.getServerlessNetworkPolicyName()) || StringUtils.isBlank((CharSequence)connectionConfiguration.getServerlessCollectionName()) || StringUtils.isBlank((CharSequence)connectionConfiguration.getServerlessVpceId())) {
            return Optional.empty();
        }
        return Optional.of(new ServerlessOptions(connectionConfiguration.getServerlessNetworkPolicyName(), connectionConfiguration.getServerlessCollectionName(), connectionConfiguration.getServerlessVpceId()));
    }

    public static Optional<ServerlessOptions> create(AwsAuthenticationConfiguration awsConfig) {
        if (awsConfig == null || !awsConfig.isServerlessCollection().booleanValue()) {
            return Optional.empty();
        }
        ServerlessOptions serverlessOptions = awsConfig.getServerlessOptions();
        if (serverlessOptions == null || StringUtils.isBlank((CharSequence)serverlessOptions.getNetworkPolicyName()) || StringUtils.isBlank((CharSequence)serverlessOptions.getCollectionName()) || StringUtils.isBlank((CharSequence)serverlessOptions.getVpceId())) {
            return Optional.empty();
        }
        return Optional.of(serverlessOptions);
    }
}

