/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.csv;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.List;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>csv</code> codec parses comma-separated values (CSVs) content into events from that content.")
public class CsvOutputCodecConfig {
    static final String DEFAULT_DELIMITER = ",";
    @JsonProperty(value="delimiter")
    @JsonPropertyDescription(value="The character separating each column. Default value is <code>,</code>.")
    private String delimiter = ",";
    @JsonProperty(value="header")
    @JsonPropertyDescription(value="User-specified names for the CSV columns.")
    private List<String> header;
    @Valid
    @Size(max=0, message="Header from file is not supported.")
    @JsonProperty(value="header_file_location")
    private @Valid @Size(max=0, message="Header from file is not supported.") String headerFileLocation;
    @Valid
    @Size(max=0, message="Header from file is not supported.")
    @JsonProperty(value="region")
    private @Valid @Size(max=0, message="Header from file is not supported.") String region;
    @Valid
    @Size(max=0, message="Header from file is not supported.")
    @JsonProperty(value="bucket_name")
    private @Valid @Size(max=0, message="Header from file is not supported.") String bucketName;
    @Valid
    @Size(max=0, message="Header from file is not supported.")
    @JsonProperty(value="fileKey")
    private @Valid @Size(max=0, message="Header from file is not supported.") String file_key;

    public String getHeaderFileLocation() {
        return this.headerFileLocation;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFile_key() {
        return this.file_key;
    }
}

