/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import io.micrometer.core.instrument.Counter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.source.coordinator.PartitionIdentifier;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartition;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotFoundException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotOwnedException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionUpdateException;
import org.opensearch.dataprepper.plugins.s3.common.ownership.BucketOwnerProvider;
import org.opensearch.dataprepper.plugins.s3.common.source.S3ObjectReference;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectDeleteWorker;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectHandler;
import org.opensearch.dataprepper.plugins.source.s3.S3ScanPartitionCreationSupplier;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceProgressState;
import org.opensearch.dataprepper.plugins.source.s3.ScanOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.FolderPartitioningOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3DataSelection;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanBucketOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanBucketOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanKeyPathOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanSchedulingOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class ScanObjectWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ScanObjectWorker.class);
    private static final Integer MAX_OBJECTS_PER_ACKNOWLEDGMENT_SET = 1;
    static final Integer MAX_RETRIES = 5;
    static final Duration CHECKPOINT_OWNERSHIP_INTERVAL = Duration.ofMinutes(2L);
    static final Duration NO_OBJECTS_FOUND_BEFORE_PARTITION_DELETION_DURATION = Duration.ofHours(1L);
    private static final int RETRY_BACKOFF_ON_EXCEPTION_MILLIS = 5000;
    static final String ACKNOWLEDGEMENT_SET_CALLBACK_METRIC_NAME = "acknowledgementSetCallbackCounter";
    static final String NO_OBJECTS_FOUND_FOR_FOLDER_PARTITION = "folderPartitionNoObjectsFound";
    static final String PARTITION_OWNERSHIP_UPDATE_ERRORS = "partitionOwnershipUpdateErrors";
    private final S3Client s3Client;
    private final List<ScanOptions> scanOptionsBuilderList;
    private final S3ObjectHandler s3ObjectHandler;
    private final BucketOwnerProvider bucketOwnerProvider;
    private final SourceCoordinator<S3SourceProgressState> sourceCoordinator;
    private final Function<Map<String, Object>, List<PartitionIdentifier>> partitionCreationSupplier;
    private final S3ScanSchedulingOptions s3ScanSchedulingOptions;
    private final boolean endToEndAcknowledgementsEnabled;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private volatile boolean isStopped = false;
    private final boolean deleteS3ObjectsOnRead;
    private final S3ObjectDeleteWorker s3ObjectDeleteWorker;
    private final PluginMetrics pluginMetrics;
    private final Counter acknowledgementSetCallbackCounter;
    private final Counter folderPartitionNoObjectsFound;
    private final Counter partitionOwnershipUpdateFailures;
    private final long backOffMs;
    private final List<String> partitionKeys;
    private final FolderPartitioningOptions folderPartitioningOptions;
    private final Map<String, Set<DeleteObjectRequest>> objectsToDeleteForAcknowledgmentSets;
    private final Map<String, AtomicInteger> acknowledgmentsRemainingForPartitions;
    private final Map<String, Map<String, S3DataSelection>> bucketDataSelectionMap;
    private final Duration acknowledgmentSetTimeout;

    public ScanObjectWorker(S3Client s3Client, List<ScanOptions> scanOptionsBuilderList, S3ObjectHandler s3ObjectHandler, BucketOwnerProvider bucketOwnerProvider, SourceCoordinator<S3SourceProgressState> sourceCoordinator, S3SourceConfig s3SourceConfig, AcknowledgementSetManager acknowledgementSetManager, S3ObjectDeleteWorker s3ObjectDeleteWorker, long backOffMs, PluginMetrics pluginMetrics) {
        this.s3Client = s3Client;
        this.backOffMs = backOffMs;
        this.scanOptionsBuilderList = scanOptionsBuilderList;
        this.s3ObjectHandler = s3ObjectHandler;
        this.bucketOwnerProvider = bucketOwnerProvider;
        this.sourceCoordinator = sourceCoordinator;
        this.s3ScanSchedulingOptions = s3SourceConfig.getS3ScanScanOptions().getSchedulingOptions();
        this.bucketDataSelectionMap = new HashMap<String, Map<String, S3DataSelection>>();
        if (s3SourceConfig.getS3ScanScanOptions().getBuckets() != null) {
            for (S3ScanBucketOptions bucketOption : s3SourceConfig.getS3ScanScanOptions().getBuckets()) {
                S3ScanBucketOption s3ScanBucketOption = bucketOption.getS3ScanBucketOption();
                if (s3ScanBucketOption == null) continue;
                String bucketName = s3ScanBucketOption.getName();
                HashMap<String, S3DataSelection> prefixMap = this.bucketDataSelectionMap.containsKey(bucketName) ? this.bucketDataSelectionMap.get(bucketName) : new HashMap<String, S3DataSelection>();
                S3ScanKeyPathOption scanFilter = s3ScanBucketOption.getS3ScanFilter();
                S3DataSelection dataSelection = s3ScanBucketOption.getDataSelection();
                if (scanFilter == null || scanFilter.getS3scanIncludePrefixOptions() == null) continue;
                for (String prefix : scanFilter.getS3scanIncludePrefixOptions()) {
                    prefixMap.put(prefix, dataSelection == null ? s3SourceConfig.getDataSelection() : dataSelection);
                }
                this.bucketDataSelectionMap.put(bucketName, prefixMap);
            }
        }
        this.endToEndAcknowledgementsEnabled = s3SourceConfig.getAcknowledgements();
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.deleteS3ObjectsOnRead = s3SourceConfig.isDeleteS3ObjectsOnRead();
        this.s3ObjectDeleteWorker = s3ObjectDeleteWorker;
        this.pluginMetrics = pluginMetrics;
        this.acknowledgementSetCallbackCounter = pluginMetrics.counter(ACKNOWLEDGEMENT_SET_CALLBACK_METRIC_NAME);
        this.folderPartitionNoObjectsFound = pluginMetrics.counter(NO_OBJECTS_FOUND_FOR_FOLDER_PARTITION);
        this.partitionOwnershipUpdateFailures = pluginMetrics.counter(PARTITION_OWNERSHIP_UPDATE_ERRORS);
        this.sourceCoordinator.initialize();
        this.partitionKeys = new ArrayList<String>();
        this.folderPartitioningOptions = s3SourceConfig.getS3ScanScanOptions().getPartitioningOptions();
        this.acknowledgmentSetTimeout = s3SourceConfig.getS3ScanScanOptions().getAcknowledgmentTimeout();
        this.partitionCreationSupplier = new S3ScanPartitionCreationSupplier(s3Client, bucketOwnerProvider, scanOptionsBuilderList, this.s3ScanSchedulingOptions, s3SourceConfig.getS3ScanScanOptions().getPartitioningOptions(), s3SourceConfig.isDeleteS3ObjectsOnRead(), sourceCoordinator);
        this.acknowledgmentsRemainingForPartitions = new ConcurrentHashMap<String, AtomicInteger>();
        this.objectsToDeleteForAcknowledgmentSets = new ConcurrentHashMap<String, Set<DeleteObjectRequest>>();
    }

    @Override
    public void run() {
        while (!this.isStopped) {
            try {
                if (System.getProperty("STOP_S3_SCAN_PROCESSING") == null) {
                    this.startProcessingObject(this.backOffMs);
                    continue;
                }
                LOG.debug("System property {} is set, S3 scan is not processing objects", (Object)"STOP_S3_SCAN_PROCESSING");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    LOG.info("S3 Scan worker thread interrupted while waiting for property {} to be set .", (Object)"STOP_S3_SCAN_PROCESSING");
                }
            }
            catch (Exception e) {
                LOG.error("Received an exception while processing S3 objects, backing off and retrying", (Throwable)e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    LOG.error("S3 Scan worker thread interrupted while backing off.", (Throwable)ex);
                }
            }
        }
        for (String partitionKey : this.partitionKeys) {
            LOG.debug("Scan object worker is stopped, giving up partitions.");
            this.sourceCoordinator.giveUpPartition(partitionKey);
        }
    }

    void runWithoutInfiniteLoop() {
        this.startProcessingObject(10L);
    }

    private void startProcessingObject(long waitTimeMillis) {
        block14: {
            Optional objectToProcess = this.sourceCoordinator.getNextPartition(this.partitionCreationSupplier, this.folderPartitioningOptions != null);
            if (objectToProcess.isEmpty()) {
                try {
                    Thread.sleep(waitTimeMillis);
                }
                catch (InterruptedException e) {
                    LOG.error("S3 Scan worker thread interrupted while backing off.", (Throwable)e);
                }
                return;
            }
            this.partitionKeys.add(((SourcePartition)objectToProcess.get()).getPartitionKey());
            if (this.folderPartitioningOptions != null) {
                try {
                    this.processFolderPartition((SourcePartition<S3SourceProgressState>)((SourcePartition)objectToProcess.get()));
                }
                catch (Exception e) {
                    LOG.error("An exception occurred while processing folder partition {}, giving up this partition", (Object)((SourcePartition)objectToProcess.get()).getPartitionKey(), (Object)e);
                    this.sourceCoordinator.giveUpPartition(((SourcePartition)objectToProcess.get()).getPartitionKey(), Instant.now(), MAX_RETRIES);
                    this.partitionKeys.remove(((SourcePartition)objectToProcess.get()).getPartitionKey());
                }
                return;
            }
            String bucket = ((SourcePartition)objectToProcess.get()).getPartitionKey().split("\\|")[0];
            String objectKey = ((SourcePartition)objectToProcess.get()).getPartitionKey().split("\\|")[1];
            try {
                AcknowledgementSet acknowledgementSet = null;
                if (this.endToEndAcknowledgementsEnabled) {
                    acknowledgementSet = this.acknowledgementSetManager.create(result -> {
                        this.acknowledgementSetCallbackCounter.increment();
                        if (result.booleanValue()) {
                            this.sourceCoordinator.completePartition(((SourcePartition)objectToProcess.get()).getPartitionKey(), Boolean.valueOf(true));
                            Set<DeleteObjectRequest> deleteObjectsForPartition = this.objectsToDeleteForAcknowledgmentSets.get(((SourcePartition)objectToProcess.get()).getPartitionKey());
                            deleteObjectsForPartition.forEach(this.s3ObjectDeleteWorker::deleteS3Object);
                            this.objectsToDeleteForAcknowledgmentSets.remove(((SourcePartition)objectToProcess.get()).getPartitionKey());
                        } else {
                            LOG.debug("Did not receive positive acknowledgement, giving up partition.");
                            this.sourceCoordinator.giveUpPartition(((SourcePartition)objectToProcess.get()).getPartitionKey());
                        }
                        this.partitionKeys.remove(((SourcePartition)objectToProcess.get()).getPartitionKey());
                    }, this.acknowledgmentSetTimeout);
                    this.addProgressCheck(acknowledgementSet, (SourcePartition<S3SourceProgressState>)((SourcePartition)objectToProcess.get()));
                }
                Optional<DeleteObjectRequest> deleteObjectRequest = this.processS3Object(S3ObjectReference.bucketAndKey((String)bucket, (String)objectKey).build(), acknowledgementSet, this.sourceCoordinator, (SourcePartition<S3SourceProgressState>)((SourcePartition)objectToProcess.get()));
                if (this.endToEndAcknowledgementsEnabled) {
                    deleteObjectRequest.ifPresent(deleteRequest -> this.objectsToDeleteForAcknowledgmentSets.put(((SourcePartition)objectToProcess.get()).getPartitionKey(), Set.of(deleteRequest)));
                    try {
                        this.sourceCoordinator.updatePartitionForAcknowledgmentWait(((SourcePartition)objectToProcess.get()).getPartitionKey(), this.acknowledgmentSetTimeout);
                    }
                    catch (PartitionUpdateException e) {
                        LOG.debug("Failed to update the partition for the acknowledgment wait.");
                    }
                    acknowledgementSet.complete();
                    break block14;
                }
                this.sourceCoordinator.completePartition(((SourcePartition)objectToProcess.get()).getPartitionKey(), Boolean.valueOf(false));
                if (this.s3ObjectDeleteWorker != null) {
                    deleteObjectRequest.ifPresent(this.s3ObjectDeleteWorker::deleteS3Object);
                }
                this.partitionKeys.remove(((SourcePartition)objectToProcess.get()).getPartitionKey());
            }
            catch (NoSuchKeyException e) {
                LOG.warn("Object {} from bucket {} could not be found, marking this object as complete and continuing processing", (Object)objectKey, (Object)bucket);
                this.sourceCoordinator.completePartition(((SourcePartition)objectToProcess.get()).getPartitionKey(), Boolean.valueOf(false));
            }
            catch (PartitionNotFoundException | PartitionNotOwnedException | PartitionUpdateException e) {
                LOG.warn("S3 scan object worker received an exception from the source coordinator. There is a potential for duplicate data from {}, giving up partition and getting next partition: {}", (Object)objectKey, (Object)e.getMessage());
                this.sourceCoordinator.giveUpPartition(((SourcePartition)objectToProcess.get()).getPartitionKey());
            }
        }
    }

    private Optional<DeleteObjectRequest> processS3Object(S3ObjectReference s3ObjectReference, AcknowledgementSet acknowledgementSet, SourceCoordinator<S3SourceProgressState> sourceCoordinator, SourcePartition<S3SourceProgressState> sourcePartition) {
        try {
            Map<String, S3DataSelection> prefixMap = this.bucketDataSelectionMap.get(s3ObjectReference.getBucketName());
            S3DataSelection dataSelection = S3DataSelection.DATA_AND_METADATA;
            String objectKey = s3ObjectReference.getKey();
            if (prefixMap != null) {
                for (Map.Entry<String, S3DataSelection> entry : prefixMap.entrySet()) {
                    if (!objectKey.startsWith(entry.getKey())) continue;
                    dataSelection = entry.getValue();
                    break;
                }
            }
            this.s3ObjectHandler.processS3Object(s3ObjectReference, dataSelection, acknowledgementSet, sourceCoordinator, sourcePartition.getPartitionKey());
            if (this.deleteS3ObjectsOnRead && this.endToEndAcknowledgementsEnabled && this.s3ObjectDeleteWorker != null) {
                DeleteObjectRequest deleteObjectRequest = this.s3ObjectDeleteWorker.buildDeleteObjectRequest(s3ObjectReference.getBucketName(), s3ObjectReference.getKey());
                return Optional.of(deleteObjectRequest);
            }
        }
        catch (IOException ex) {
            LOG.error("Error while process the processS3Object. ", (Throwable)ex);
        }
        return Optional.empty();
    }

    private void processFolderPartition(SourcePartition<S3SourceProgressState> folderPartition) {
        String bucket = folderPartition.getPartitionKey().split("\\|")[0];
        String s3Prefix = folderPartition.getPartitionKey().split("\\|")[1];
        List<S3ObjectReference> objectsToProcess = this.getObjectsForPrefix(bucket, s3Prefix);
        Optional<S3SourceProgressState> folderPartitionState = folderPartition.getPartitionState();
        if (folderPartitionState.isEmpty()) {
            folderPartitionState = Optional.of(new S3SourceProgressState(Instant.now().toEpochMilli()));
            this.sourceCoordinator.saveProgressStateForPartition(folderPartition.getPartitionKey(), (Object)folderPartitionState.get());
        }
        if (objectsToProcess.isEmpty()) {
            this.folderPartitionNoObjectsFound.increment();
            this.partitionKeys.remove(folderPartition.getPartitionKey());
            if (this.shouldDeleteFolderPartition(folderPartition)) {
                LOG.info("Deleting folder partition {} as no objects have been found from this folder for {} minutes", (Object)folderPartition.getPartitionKey(), (Object)NO_OBJECTS_FOUND_BEFORE_PARTITION_DELETION_DURATION.toMinutes());
                this.sourceCoordinator.deletePartition(folderPartition.getPartitionKey());
                return;
            }
            LOG.debug("No objects to process, giving up partition");
            this.sourceCoordinator.giveUpPartition(folderPartition.getPartitionKey(), Instant.now(), MAX_RETRIES);
            return;
        }
        folderPartitionState.ifPresent(state -> state.setLastTimeObjectsFound(Instant.now().toEpochMilli()));
        this.sourceCoordinator.saveProgressStateForPartition(folderPartition.getPartitionKey(), (Object)folderPartitionState.get());
        this.processObjectsForFolderPartition(objectsToProcess, folderPartition);
    }

    private List<S3ObjectReference> getObjectsForPrefix(String bucket, String s3Prefix) {
        ListObjectsV2Response listObjectsV2Response = null;
        ArrayList<S3ObjectReference> objectsToProcess = new ArrayList<S3ObjectReference>();
        ListObjectsV2Request.Builder listObjectsV2Request = ListObjectsV2Request.builder().bucket(bucket).prefix(s3Prefix);
        do {
            listObjectsV2Response = this.s3Client.listObjectsV2((ListObjectsV2Request)listObjectsV2Request.fetchOwner(Boolean.valueOf(true)).continuationToken(Objects.nonNull(listObjectsV2Response) ? listObjectsV2Response.nextContinuationToken() : null).build());
            LOG.debug("Found page of {} objects from bucket {} and prefix {}", new Object[]{listObjectsV2Response.keyCount(), bucket, s3Prefix});
            objectsToProcess.addAll(listObjectsV2Response.contents().stream().map(s3Object -> S3ObjectReference.bucketAndKey((String)bucket, (String)s3Object.key()).build()).collect(Collectors.toList()));
        } while (listObjectsV2Response.isTruncated().booleanValue());
        return objectsToProcess;
    }

    void stop() {
        this.isStopped = true;
        Thread.currentThread().interrupt();
    }

    private boolean shouldDeleteFolderPartition(SourcePartition<S3SourceProgressState> folderPartition) {
        return folderPartition.getPartitionState().isPresent() && Instant.now().toEpochMilli() - ((S3SourceProgressState)folderPartition.getPartitionState().get()).getLastTimeObjectsFound() > NO_OBJECTS_FOUND_BEFORE_PARTITION_DELETION_DURATION.toMillis();
    }

    private void processObjectsForFolderPartition(List<S3ObjectReference> objectsToProcess, SourcePartition<S3SourceProgressState> folderPartition) {
        int objectsProcessed = 0;
        String activeAcknowledgmentSetId = null;
        AcknowledgementSet acknowledgementSet = null;
        for (int objectIndex = 0; objectIndex < objectsToProcess.size() && objectsProcessed < this.folderPartitioningOptions.getMaxObjectsPerOwnership(); ++objectsProcessed, ++objectIndex) {
            Optional<DeleteObjectRequest> deleteObjectRequest;
            S3ObjectReference s3ObjectReference = objectsToProcess.get(objectIndex);
            if (objectsProcessed % MAX_OBJECTS_PER_ACKNOWLEDGMENT_SET == 0) {
                String acknowledgmentSetId;
                if (acknowledgementSet != null) {
                    acknowledgementSet.complete();
                }
                activeAcknowledgmentSetId = acknowledgmentSetId = UUID.randomUUID().toString();
                acknowledgementSet = this.createAcknowledgmentSetForFolderPartition(folderPartition, acknowledgmentSetId);
                this.addProgressCheck(acknowledgementSet, folderPartition);
                this.objectsToDeleteForAcknowledgmentSets.put(acknowledgmentSetId, new HashSet());
                AtomicInteger acknowledgmentsRemainingForPartition = this.acknowledgmentsRemainingForPartitions.containsKey(folderPartition.getPartitionKey()) ? this.acknowledgmentsRemainingForPartitions.get(folderPartition.getPartitionKey()) : new AtomicInteger();
                acknowledgmentsRemainingForPartition.incrementAndGet();
                this.acknowledgmentsRemainingForPartitions.put(folderPartition.getPartitionKey(), acknowledgmentsRemainingForPartition);
            }
            if (!(deleteObjectRequest = this.processS3Object(s3ObjectReference, acknowledgementSet, this.sourceCoordinator, folderPartition)).isPresent()) continue;
            this.objectsToDeleteForAcknowledgmentSets.get(activeAcknowledgmentSetId).add(deleteObjectRequest.get());
        }
        this.sourceCoordinator.updatePartitionForAcknowledgmentWait(folderPartition.getPartitionKey(), this.acknowledgmentSetTimeout);
        if (acknowledgementSet != null) {
            acknowledgementSet.complete();
        }
    }

    private AcknowledgementSet createAcknowledgmentSetForFolderPartition(SourcePartition<S3SourceProgressState> folderPartition, String acknowledgmentSetId) {
        return this.acknowledgementSetManager.create(result -> {
            this.acknowledgementSetCallbackCounter.increment();
            if (result.booleanValue()) {
                Set<DeleteObjectRequest> deleteObjectsForPartition = this.objectsToDeleteForAcknowledgmentSets.get(acknowledgmentSetId);
                deleteObjectsForPartition.forEach(this.s3ObjectDeleteWorker::deleteS3Object);
            }
            this.acknowledgmentsRemainingForPartitions.get(folderPartition.getPartitionKey()).decrementAndGet();
            if (this.acknowledgmentsRemainingForPartitions.get(folderPartition.getPartitionKey()).intValue() == 0) {
                this.acknowledgmentsRemainingForPartitions.remove(folderPartition.getPartitionKey());
                this.objectsToDeleteForAcknowledgmentSets.remove(acknowledgmentSetId);
                this.partitionKeys.remove(folderPartition.getPartitionKey());
                LOG.info("Received all acknowledgments for folder partition {}, giving up this partition", (Object)folderPartition.getPartitionKey());
                this.sourceCoordinator.giveUpPartition(folderPartition.getPartitionKey(), Instant.now(), MAX_RETRIES);
            }
        }, this.acknowledgmentSetTimeout);
    }

    private void addProgressCheck(AcknowledgementSet acknowledgementSet, SourcePartition<S3SourceProgressState> objectToProcess) {
        acknowledgementSet.addProgressCheck(ratio -> {
            try {
                this.sourceCoordinator.renewPartitionOwnership(objectToProcess.getPartitionKey());
            }
            catch (PartitionNotFoundException | PartitionNotOwnedException | PartitionUpdateException e) {
                LOG.debug("Failed to update partition ownership for {} in the acknowledgment progress check", (Object)objectToProcess.getPartitionKey());
                this.partitionOwnershipUpdateFailures.increment();
            }
        }, CHECKPOINT_OWNERSHIP_INTERVAL);
    }
}

