/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.QueryParamsBuilder;
import com.linecorp.armeria.internal.common.PercentDecoder;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;

final class QueryStringDecoder {
    /*
     * Enabled aggressive block sorting
     */
    static QueryParams decodeParams(TemporaryThreadLocals tempThreadLocals, String s, int paramsLimit, boolean semicolonAsSeparator) {
        int i;
        QueryParamsBuilder params = QueryParams.builder();
        int len = s.length();
        int nameStart = 0;
        int valueStart = 0;
        block6: for (i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '=': {
                    if (valueStart != 0) break;
                    valueStart = i + 1;
                    break;
                }
                case ';': {
                    if (!semicolonAsSeparator) break;
                }
                case '&': {
                    if (QueryStringDecoder.addParam(tempThreadLocals, params, s, nameStart, valueStart, i) && --paramsLimit == 0) {
                        return params.build();
                    }
                    nameStart = i + 1;
                    valueStart = 0;
                    break;
                }
                case '#': {
                    break block6;
                }
            }
        }
        QueryStringDecoder.addParam(tempThreadLocals, params, s, nameStart, valueStart, i);
        return params.build();
    }

    private static boolean addParam(TemporaryThreadLocals tempThreadLocals, QueryParamsBuilder params, String s, int nameStart, int valueStart, int end) {
        String value;
        String name;
        if (nameStart == end) {
            return false;
        }
        if (valueStart == 0) {
            name = PercentDecoder.decodeComponent(tempThreadLocals, s, nameStart, end);
            value = "";
        } else {
            name = PercentDecoder.decodeComponent(tempThreadLocals, s, nameStart, valueStart - 1);
            value = PercentDecoder.decodeComponent(tempThreadLocals, s, valueStart, end);
        }
        params.add(name, value);
        return true;
    }

    private QueryStringDecoder() {
    }
}

