/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.processor;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.lambda.common.LambdaCommonHandler;
import org.opensearch.dataprepper.plugins.lambda.common.StreamingLambdaHandler;
import org.opensearch.dataprepper.plugins.lambda.common.accumlator.Buffer;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaInvoker;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaProcessor;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;

public class StreamingLambdaInvoker
implements LambdaInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingLambdaInvoker.class);
    private static final int ESTIMATED_BYTES_PER_RECORD = 1024;
    private final LambdaProcessor processor;
    private final StreamingLambdaHandler streamingHandler;

    public StreamingLambdaInvoker(LambdaProcessorConfig lambdaProcessorConfig, LambdaAsyncClient lambdaAsyncClient, InputCodec responseCodec, LambdaProcessor processor) {
        this.processor = processor;
        this.streamingHandler = new StreamingLambdaHandler(lambdaAsyncClient, processor.pluginFactory, responseCodec, lambdaProcessorConfig.getFunctionName(), lambdaProcessorConfig.getStreamingOptions());
    }

    @Override
    public Collection<Record<Event>> invoke(List<Record<Event>> recordsToLambda, List<Record<Event>> resultRecords) {
        Map<Buffer, CompletableFuture<InvokeResponse>> bufferMap;
        try {
            bufferMap = LambdaCommonHandler.sendRecords(recordsToLambda, this.processor.lambdaProcessorConfig, this.processor.lambdaAsyncClient, new OutputCodecContext());
        }
        catch (Exception e) {
            LOG.error(DataPrepperMarkers.NOISY, "Error creating buffers for streaming", (Throwable)e);
            this.processor.numberOfRecordsFailedCounter.increment((double)recordsToLambda.size());
            this.processor.numberOfRequestsFailedCounter.increment();
            resultRecords.addAll(this.processor.addFailureTags(recordsToLambda));
            return resultRecords;
        }
        for (Map.Entry<Buffer, CompletableFuture<InvokeResponse>> entry : bufferMap.entrySet()) {
            Buffer inputBuffer = entry.getKey();
            try {
                CompletableFuture<List<Record<Event>>> streamingFuture = this.streamingHandler.invokeWithStreaming(inputBuffer);
                List<Record<Event>> streamingRecords = streamingFuture.get();
                resultRecords.addAll(streamingRecords);
                Duration latency = inputBuffer.stopLatencyWatch();
                this.processor.lambdaLatencyMetric.record(latency.toMillis(), TimeUnit.MILLISECONDS);
                this.processor.requestPayloadMetric.record((double)inputBuffer.getPayloadRequestSize().longValue());
                int estimatedResponseSize = streamingRecords.size() * 1024;
                this.processor.responsePayloadMetric.record((double)estimatedResponseSize);
                this.processor.numberOfRecordsSuccessCounter.increment((double)streamingRecords.size());
                this.processor.numberOfRequestsSuccessCounter.increment();
                this.processor.lambdaResponseRecordsCounter.increment((double)streamingRecords.size());
            }
            catch (ResourceNotFoundException e) {
                LOG.error(DataPrepperMarkers.NOISY, "Lambda function not found: {}", (Object)e.getMessage());
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
            catch (LambdaException e) {
                LOG.error(DataPrepperMarkers.NOISY, "Lambda invocation failed: {}", (Object)e.getMessage());
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
            catch (AwsServiceException e) {
                LOG.error(DataPrepperMarkers.NOISY, "AWS service error during Lambda invocation: {}", (Object)e.getMessage());
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Unexpected error processing streaming Lambda response.", (Throwable)e);
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
        }
        return resultRecords;
    }
}

