/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import java.util.List;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.lambda.common.config.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.lambda.common.config.BatchOptions;
import org.opensearch.dataprepper.plugins.lambda.common.config.ClientOptions;
import org.opensearch.dataprepper.plugins.lambda.common.config.InvocationType;
import org.opensearch.dataprepper.plugins.lambda.common.config.StreamingOptions;

public abstract class LambdaCommonConfig {
    public static final int DEFAULT_CONNECTION_RETRIES = 3;
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    public static final String STS_REGION = "region";
    public static final String STS_ROLE_ARN = "sts_role_arn";
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationOptions awsAuthenticationOptions;
    @JsonPropertyDescription(value="Lambda Function Name")
    @JsonProperty(value="function_name")
    @NotEmpty
    @Size(min=3, max=500, message="function name length should be at least 3 characters")
    private @NotEmpty @Size(min=3, max=500, message="function name length should be at least 3 characters") String functionName;
    @JsonPropertyDescription(value="invocation type defines the way we want to call lambda function")
    @JsonProperty(value="invocation_type")
    private InvocationType invocationType = InvocationType.REQUEST_RESPONSE;
    @JsonPropertyDescription(value="Client options")
    @JsonProperty(value="client")
    private ClientOptions clientOptions = new ClientOptions();
    @JsonPropertyDescription(value="Batch options")
    @JsonProperty(value="batch")
    private BatchOptions batchOptions = new BatchOptions();
    @JsonPropertyDescription(value="Codec configuration for parsing Lambda responses")
    @JsonProperty(value="response_codec")
    @Valid
    private PluginModel responseCodecConfig;
    @JsonPropertyDescription(value="Keys to send to lambda")
    @JsonProperty(value="keys")
    private List<String> keys;
    @JsonPropertyDescription(value="Streaming options for Lambda response streaming")
    @JsonProperty(value="streaming")
    @Valid
    private StreamingOptions streamingOptions;

    public boolean hasKeys() {
        return this.keys != null && this.keys.size() > 0;
    }

    public StreamingOptions getStreamingOptions() {
        return this.streamingOptions;
    }

    public abstract InvocationType getInvocationType();

    public AwsAuthenticationOptions getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public BatchOptions getBatchOptions() {
        return this.batchOptions;
    }

    public PluginModel getResponseCodecConfig() {
        return this.responseCodecConfig;
    }

    public List<String> getKeys() {
        return this.keys;
    }
}

