/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.opensearch.common.ParsingException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.join.aggregations.ChildrenToParentAggregator;
import org.opensearch.join.aggregations.ParentAggregatorFactory;
import org.opensearch.join.mapper.ParentIdFieldMapper;
import org.opensearch.join.mapper.ParentJoinFieldMapper;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public class ParentAggregationBuilder
extends ValuesSourceAggregationBuilder<ParentAggregationBuilder> {
    public static final String NAME = "parent";
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ParentAggregationBuilder(String name, String childType) {
        super(name);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    protected ParentAggregationBuilder(ParentAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metadata);
        this.childType = clone.childType;
        this.childFilter = clone.childFilter;
        this.parentFilter = clone.parentFilter;
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ParentAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ParentAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.childType = in.readString();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    protected ValuesSourceAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ParentAggregatorFactory(this.name, config, this.childFilter, this.parentFilter, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    protected ValuesSourceConfig resolveConfig(QueryShardContext queryShardContext) {
        ValuesSourceConfig config;
        ParentJoinFieldMapper parentJoinFieldMapper = ParentJoinFieldMapper.getMapper(queryShardContext.getMapperService());
        ParentIdFieldMapper parentIdFieldMapper = parentJoinFieldMapper.getParentIdFieldMapper(this.childType, false);
        if (parentIdFieldMapper != null) {
            this.parentFilter = parentIdFieldMapper.getParentFilter();
            this.childFilter = parentIdFieldMapper.getChildFilter(this.childType);
            MappedFieldType fieldType = parentIdFieldMapper.fieldType();
            config = ValuesSourceConfig.resolveFieldOnly((MappedFieldType)fieldType, (QueryShardContext)queryShardContext);
        } else {
            config = ValuesSourceConfig.resolveUnmapped((ValuesSourceType)this.defaultValueSourceType(), (QueryShardContext)queryShardContext);
        }
        return config;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ChildrenToParentAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ParentAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for parent aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ParentAggregationBuilder(aggregationName, childType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.childType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ParentAggregationBuilder other = (ParentAggregationBuilder)((Object)obj);
        return Objects.equals(this.childType, other.childType);
    }

    public String getType() {
        return NAME;
    }

    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return ValuesSourceRegistry.UNREGISTERED_KEY;
    }
}

