/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.event;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.event.DefaultEventBuilderFactory;
import org.opensearch.dataprepper.model.event.BaseEventBuilder;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventFactory;

@Named
public class DefaultEventFactory
implements EventFactory {
    private final Map<Class<?>, DefaultEventBuilderFactory> classToFactoryMap;

    @Inject
    DefaultEventFactory(Collection<DefaultEventBuilderFactory> factories) {
        this.classToFactoryMap = factories.stream().collect(Collectors.toMap(DefaultEventBuilderFactory::getEventClass, v -> v));
    }

    public <T extends Event, B extends BaseEventBuilder<T>> B eventBuilder(Class<B> eventBuilderClass) throws UnsupportedOperationException {
        if (!this.classToFactoryMap.containsKey(eventBuilderClass)) {
            throw new UnsupportedOperationException("Unsupported class");
        }
        return (B)this.classToFactoryMap.get(eventBuilderClass).createNew();
    }
}

