/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.util;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Item;
import java.util.Comparator;
import java.util.Objects;

public final class ItemComparator {
    private static final String MUST_NOT_BE_NULL_MESSAGE = "Date time parser must not be null";

    private ItemComparator() {
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static <I extends Item> Comparator<I> oldestItemFirst() {
        return ItemComparator.oldestPublishedItemFirst();
    }

    public static <I extends Item> Comparator<I> oldestPublishedItemFirst() {
        return Comparator.comparing(i -> i.getPubDateAsZonedDateTime().orElse(null), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public static <I extends Item> Comparator<I> oldestUpdatedItemFirst() {
        return Comparator.comparing(i -> i.getUpdatedAsZonedDateTime().orElse(i.getPubDateAsZonedDateTime().orElse(null)), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static <I extends Item> Comparator<I> oldestItemFirst(DateTimeParser dateTimeParser) {
        return ItemComparator.oldestPublishedItemFirst(dateTimeParser);
    }

    public static <I extends Item> Comparator<I> oldestPublishedItemFirst(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, MUST_NOT_BE_NULL_MESSAGE);
        return Comparator.comparing(i -> i.getPubDate().map(dateTimeParser::parse).orElse(null), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public static <I extends Item> Comparator<I> oldestUpdatedItemFirst(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, MUST_NOT_BE_NULL_MESSAGE);
        return Comparator.comparing(i -> i.getUpdated().or(i::getPubDate).map(dateTimeParser::parse).orElse(null), Comparator.nullsLast(Comparator.naturalOrder()));
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static <I extends Item> Comparator<I> newestItemFirst() {
        return ItemComparator.newestPublishedItemFirst();
    }

    public static <I extends Item> Comparator<I> newestPublishedItemFirst() {
        return Comparator.comparing(i -> i.getPubDateAsZonedDateTime().orElse(null), Comparator.nullsLast(Comparator.naturalOrder())).reversed();
    }

    public static <I extends Item> Comparator<I> newestUpdatedItemFirst() {
        return Comparator.comparing(i -> i.getUpdatedAsZonedDateTime().orElse(i.getPubDateAsZonedDateTime().orElse(null)), Comparator.nullsLast(Comparator.naturalOrder())).reversed();
    }

    @Deprecated(since="3.9.0", forRemoval=true)
    public static <I extends Item> Comparator<I> newestItemFirst(DateTimeParser dateTimeParser) {
        return ItemComparator.newestPublishedItemFirst(dateTimeParser);
    }

    public static <I extends Item> Comparator<I> newestPublishedItemFirst(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, MUST_NOT_BE_NULL_MESSAGE);
        return Comparator.comparing(i -> i.getPubDate().map(dateTimeParser::parse).orElse(null), Comparator.nullsLast(Comparator.naturalOrder())).reversed();
    }

    public static <I extends Item> Comparator<I> newestUpdatedItemFirst(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, MUST_NOT_BE_NULL_MESSAGE);
        return Comparator.comparing(i -> i.getUpdated().or(i::getPubDate).map(dateTimeParser::parse).orElse(null), Comparator.nullsLast(Comparator.naturalOrder())).reversed();
    }

    public static <I extends Item> Comparator<I> channelTitle() {
        return Comparator.comparing(Item::getChannel, Comparator.nullsFirst(Comparator.comparing(Channel::getTitle, Comparator.nullsFirst(Comparator.naturalOrder()))));
    }
}

