/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.logstash.exception.LogstashConfigurationException;
import org.opensearch.dataprepper.logstash.mapping.AbstractLogstashPluginAttributesMapper;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.mapping.NestedSyntaxConverter;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;
import org.opensearch.dataprepper.logstash.model.LogstashValueType;
import org.opensearch.dataprepper.plugins.processor.date.DateProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateLogstashPluginAttributesMapper
extends AbstractLogstashPluginAttributesMapper {
    private static final Logger LOG = LoggerFactory.getLogger(DateLogstashPluginAttributesMapper.class);
    protected static final String LOGSTASH_DATE_MATCH_ATTRIBUTE_NAME = "match";

    @Override
    protected void mapCustomAttributes(List<LogstashAttribute> logstashAttributes, LogstashAttributesMappings logstashAttributesMappings, Map<String, Object> pluginSettings) {
        LogstashAttribute matchAttribute = logstashAttributes.stream().filter(logstashAttribute -> logstashAttribute.getAttributeName().equals(LOGSTASH_DATE_MATCH_ATTRIBUTE_NAME)).findFirst().orElseThrow(() -> new LogstashConfigurationException("Missing date match setting in Logstash configuration"));
        DateProcessorConfig.DateMatch matchAttributeConvertedValue = this.convertMatchAttribute(matchAttribute);
        pluginSettings.put(logstashAttributesMappings.getMappedAttributeNames().get(LOGSTASH_DATE_MATCH_ATTRIBUTE_NAME), Collections.singletonList(matchAttributeConvertedValue));
    }

    @Override
    protected HashSet<String> getCustomMappedAttributeNames() {
        return new HashSet<String>(Collections.singletonList(LOGSTASH_DATE_MATCH_ATTRIBUTE_NAME));
    }

    private DateProcessorConfig.DateMatch convertMatchAttribute(LogstashAttribute matchAttribute) {
        if (matchAttribute.getAttributeValue().getAttributeValueType().equals((Object)LogstashValueType.ARRAY)) {
            List logstashDateMatchCastValue = (List)matchAttribute.getAttributeValue().getValue();
            if (logstashDateMatchCastValue.size() >= 2) {
                String logstashAttributeValue = NestedSyntaxConverter.convertNestedSyntaxToJsonPointer((String)logstashDateMatchCastValue.get(0));
                return new DateProcessorConfig.DateMatch(logstashAttributeValue, logstashDateMatchCastValue.subList(1, logstashDateMatchCastValue.size()));
            }
            LOG.debug("Logstash date match should have field name and at least one pattern.");
        }
        return null;
    }
}

