/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension.databasedownload;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.opensearch.dataprepper.plugins.geoip.exception.DownloadFailedException;
import org.opensearch.dataprepper.plugins.geoip.extension.MaxMindDatabaseConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DBSource;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.Manifest;

public class ManifestDownloadService
implements DBSource {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int DEFAULT_BYTE_SIZE = 1024;
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private final String directoryName;
    private final MaxMindDatabaseConfig maxMindDatabaseConfig;

    public ManifestDownloadService(String directoryName, MaxMindDatabaseConfig maxMindDatabaseConfig) {
        this.directoryName = directoryName;
        this.maxMindDatabaseConfig = maxMindDatabaseConfig;
    }

    @Override
    public void initiateDownload() {
        Set<String> databasePaths = this.maxMindDatabaseConfig.getDatabasePaths().keySet();
        for (String key : databasePaths) {
            Manifest manifest = this.deserializeManifestFile(this.maxMindDatabaseConfig.getDatabasePaths().get(key));
            String manifestFilePath = manifest.getDbName();
            String zipFileName = manifestFilePath.substring(0, manifestFilePath.lastIndexOf(".")).concat(ZIP_FILE_EXTENSION);
            String zipFilePath = this.directoryName + File.separator + zipFileName;
            this.downloadZipFile(manifest.getUrl(), zipFilePath);
            this.unzipDownloadedFile(zipFilePath, this.directoryName, key + ".mmdb");
        }
    }

    private Manifest deserializeManifestFile(String CDNEndpoint) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL url = new URL(CDNEndpoint);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.addRequestProperty("User-Agent", "Data Prepper");
            Manifest manifest = (Manifest)OBJECT_MAPPER.readValue(httpURLConnection.getInputStream(), Manifest.class);
            httpURLConnection.disconnect();
            return manifest;
        }
        catch (IOException ex) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw new DownloadFailedException("Exception occurred while reading manifest.json file due to: " + ex.getMessage());
        }
    }

    private void downloadZipFile(String databaseUrl, String destinationPath) {
        HttpURLConnection httpURLConnection;
        try {
            URL url = new URL(databaseUrl);
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.addRequestProperty("User-Agent", "Data Prepper");
        }
        catch (IOException ex) {
            throw new DownloadFailedException("Exception occurred while opening connection due to: " + ex.getMessage());
        }
        try (BufferedInputStream in = new BufferedInputStream(httpURLConnection.getInputStream());
             FileOutputStream fileOutputStream = new FileOutputStream(destinationPath);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            httpURLConnection.disconnect();
        }
        catch (IOException ex) {
            httpURLConnection.disconnect();
            throw new DownloadFailedException("Exception occurred while downloading MaxMind database due to: " + ex.getMessage());
        }
    }

    private void unzipDownloadedFile(String zipFilePath, String outputFilePath, String fileName) {
        File inputFile = new File(zipFilePath);
        File outputDir = new File(outputFilePath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try (FileInputStream fileInputStream = new FileInputStream(inputFile);
             ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && zipEntry.getName().endsWith(".mmdb")) {
                int len;
                File newFile = new File(String.valueOf(outputDir) + File.separator + fileName);
                FileOutputStream fileOutputStream = new FileOutputStream(newFile);
                while ((len = zipInputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, len);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            inputFile.delete();
        }
        catch (IOException e) {
            inputFile.delete();
            throw new DownloadFailedException("Exception occurred while unzipping the database file due to: " + e.getMessage());
        }
    }
}

