/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.DecoderException;
import org.opensearch.dataprepper.model.log.OpenTelemetryLog;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.trace.Span;

public interface OTelProtoCodec {
    public static final int DEFAULT_EXPONENTIAL_HISTOGRAM_MAX_ALLOWED_SCALE = 10;

    public static interface OTelProtoEncoder {
        public ResourceSpans convertToResourceSpans(Span var1) throws UnsupportedEncodingException, DecoderException;
    }

    public static interface OTelProtoDecoder {
        public static final String SERVICE_NAME = "service.name";
        public static final String SERVICE_NAME_KEY = "service_name";

        public List<Span> parseExportTraceServiceRequest(ExportTraceServiceRequest var1, Instant var2);

        public Map<String, ExportTraceServiceRequest> splitExportTraceServiceRequestByTraceId(ExportTraceServiceRequest var1);

        public static Optional<String> getServiceName(Resource resource) {
            return resource.getAttributesList().stream().filter(keyValue -> keyValue.getKey().equals(SERVICE_NAME) && !keyValue.getValue().getStringValue().isEmpty()).findFirst().map(i -> i.getValue().getStringValue());
        }

        public List<OpenTelemetryLog> parseExportLogsServiceRequest(ExportLogsServiceRequest var1, Instant var2);

        default public Map<String, ExportMetricsServiceRequest> splitExportMetricsServiceRequestByKeys(ExportMetricsServiceRequest request, Set<String> keys) {
            HashMap builderMap = new HashMap();
            request.getResourceMetricsList().forEach(resourceMetrics -> this.splitResourceMetricsByKeys((ResourceMetrics)resourceMetrics, keys).forEach((key, value) -> builderMap.computeIfAbsent(key, k -> ExportMetricsServiceRequest.newBuilder()).addResourceMetrics(value)));
            return builderMap.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), ((ExportMetricsServiceRequest.Builder)entry.getValue()).build()), HashMap::putAll);
        }

        private Map<String, ResourceMetrics> splitResourceMetricsByKeys(ResourceMetrics resourceMetrics, Set<String> keys) {
            Resource resource = resourceMetrics.getResource();
            Object entryKeyPrefix = "";
            if (keys.contains(SERVICE_NAME_KEY)) {
                entryKeyPrefix = OTelProtoDecoder.getServiceName(resource).orElse("");
                entryKeyPrefix = (String)entryKeyPrefix + ":";
            }
            boolean hasResource = resourceMetrics.hasResource();
            HashMap<String, ResourceMetrics> result = new HashMap<String, ResourceMetrics>();
            HashMap<String, ResourceMetrics.Builder> resultBuilderMap = new HashMap<String, ResourceMetrics.Builder>();
            if (!resourceMetrics.getScopeMetricsList().isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.splitScopeMetricsByKeys(resourceMetrics.getScopeMetricsList(), (String)entryKeyPrefix).entrySet()) {
                    ResourceMetrics.Builder resourceMetricsBuilder = ResourceMetrics.newBuilder().addAllScopeMetrics((Iterable)entry.getValue());
                    if (hasResource) {
                        resourceMetricsBuilder.setResource(resource);
                    }
                    resultBuilderMap.put((String)entry.getKey(), resourceMetricsBuilder);
                }
            }
            for (Map.Entry<Object, Object> entry : resultBuilderMap.entrySet()) {
                result.put((String)entry.getKey(), ((ResourceMetrics.Builder)entry.getValue()).build());
            }
            return result;
        }

        private Map<String, List<ScopeMetrics>> splitScopeMetricsByKeys(List<ScopeMetrics> scopeMetricsList, String prefix) {
            HashMap<String, List<ScopeMetrics>> result = new HashMap<String, List<ScopeMetrics>>();
            for (ScopeMetrics sm : scopeMetricsList) {
                boolean hasScope = sm.hasScope();
                InstrumentationScope scope = sm.getScope();
                for (Map.Entry<String, List<io.opentelemetry.proto.metrics.v1.Metric>> entry : this.splitMetricsByKeys(sm.getMetricsList(), prefix).entrySet()) {
                    String key;
                    ScopeMetrics.Builder scopeMetricsBuilder = ScopeMetrics.newBuilder().addAllMetrics((Iterable)entry.getValue());
                    if (hasScope) {
                        scopeMetricsBuilder.setScope(scope);
                    }
                    if (!result.containsKey(key = entry.getKey())) {
                        result.put(key, new ArrayList());
                    }
                    ((List)result.get(key)).add(scopeMetricsBuilder.build());
                }
            }
            return result;
        }

        private Map<String, List<io.opentelemetry.proto.metrics.v1.Metric>> splitMetricsByKeys(List<io.opentelemetry.proto.metrics.v1.Metric> metrics, String prefix) {
            HashMap<String, List<io.opentelemetry.proto.metrics.v1.Metric>> result = new HashMap<String, List<io.opentelemetry.proto.metrics.v1.Metric>>();
            for (io.opentelemetry.proto.metrics.v1.Metric metric : metrics) {
                List<io.opentelemetry.proto.metrics.v1.Metric> metricList;
                String key = prefix + metric.getName();
                if (result.containsKey(key)) {
                    metricList = (List)result.get(key);
                } else {
                    metricList = new ArrayList();
                    result.put(key, metricList);
                }
                metricList.add(metric);
            }
            return result;
        }

        default public Collection<Record<? extends Metric>> parseExportMetricsServiceRequest(ExportMetricsServiceRequest request, Instant timeReceived) {
            AtomicInteger droppedCounter = new AtomicInteger(0);
            return this.parseExportMetricsServiceRequest(request, droppedCounter, 10, timeReceived, true, true, true);
        }

        public Collection<Record<? extends Metric>> parseExportMetricsServiceRequest(ExportMetricsServiceRequest var1, AtomicInteger var2, Integer var3, Instant var4, boolean var5, boolean var6, boolean var7);
    }
}

