/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.InvalidPluginDefinitionException;
import org.opensearch.dataprepper.model.plugin.PluginInvocationException;
import org.opensearch.dataprepper.plugin.PluginArgumentsContext;
import org.opensearch.dataprepper.plugin.PluginConfigurationObservableRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PluginCreator {
    private static final Logger LOG = LoggerFactory.getLogger(PluginCreator.class);
    private final PluginConfigurationObservableRegister pluginConfigurationObservableRegister;

    PluginCreator() {
        this.pluginConfigurationObservableRegister = null;
    }

    PluginCreator(PluginConfigurationObservableRegister pluginConfigurationObservableRegister) {
        this.pluginConfigurationObservableRegister = pluginConfigurationObservableRegister;
    }

    <T> T newPluginInstance(Class<T> pluginClass, PluginArgumentsContext pluginArgumentsContext, String pluginName, Object ... args) {
        Objects.requireNonNull(pluginClass);
        Objects.requireNonNull(pluginArgumentsContext);
        Objects.requireNonNull(pluginName);
        Constructor<?> constructor = this.getConstructor(pluginClass, pluginName);
        Object[] constructorArguments = pluginArgumentsContext.createArguments(constructor.getParameterTypes(), args);
        if (this.pluginConfigurationObservableRegister != null) {
            this.pluginConfigurationObservableRegister.registerPluginConfigurationObservables(constructorArguments);
        }
        try {
            return (T)constructor.newInstance(constructorArguments);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOG.error("Encountered exception while instantiating the plugin {}", (Object)pluginClass.getSimpleName(), (Object)ex);
            throw new InvalidPluginDefinitionException("Unable to access or instantiate the plugin \"" + pluginName + "\".", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            LOG.error("Encountered exception while instantiating the plugin {}", (Object)pluginClass.getSimpleName(), (Object)ex);
            throw new PluginInvocationException("Exception thrown from plugin \"" + pluginName + "\".", ex.getTargetException());
        }
    }

    private <T> Constructor<?> getConstructor(Class<T> pluginClass, String pluginName) {
        Constructor<?>[] constructors = pluginClass.getConstructors();
        Optional<Constructor<?>> annotatedConstructor = this.getAnnotatedConstructor(pluginClass, constructors);
        if (annotatedConstructor.isPresent()) {
            return annotatedConstructor.get();
        }
        Optional<Constructor> pluginSettingOnlyConstructor = Arrays.stream(constructors).filter(c -> Arrays.equals(c.getParameterTypes(), new Class[]{PluginSetting.class})).findFirst();
        if (pluginSettingOnlyConstructor.isPresent()) {
            return pluginSettingOnlyConstructor.get();
        }
        Optional<Constructor> defaultConstructor = Arrays.stream(constructors).filter(c -> c.getParameterTypes().length == 0).findFirst();
        if (defaultConstructor.isPresent()) {
            return defaultConstructor.get();
        }
        String error = String.format("Data Prepper plugin %s with name %s does not have a valid plugin constructor. Please ensure the plugin has a constructor that either: 1. Is annotated with @DataPrepperPluginConstructor; 2. Contains a single argument of type PluginSetting; or 3. Is the default constructor.", pluginClass.getSimpleName(), pluginName);
        LOG.error("{}", (Object)error);
        throw new InvalidPluginDefinitionException(error);
    }

    private Optional<Constructor<?>> getAnnotatedConstructor(Class<?> pluginClass, Constructor<?>[] constructors) {
        List annotatedConstructors = Arrays.stream(constructors).filter(c -> c.isAnnotationPresent(DataPrepperPluginConstructor.class)).collect(Collectors.toList());
        if (annotatedConstructors.size() > 1) {
            throw new InvalidPluginDefinitionException("The plugin type " + String.valueOf(pluginClass) + " has more than one constructor annotated with @DataPrepperPluginConstructor. At most one constructor may have this annotation.");
        }
        if (annotatedConstructors.size() == 1) {
            return Optional.of((Constructor)annotatedConstructors.get(0));
        }
        return Optional.empty();
    }
}

