/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.model;

import java.util.Arrays;
import java.util.stream.Collectors;

public class ExportObjectKey {
    static final String S3_PATH_DELIMITER = "/";
    private final String prefix;
    private final String exportTaskId;
    private final String databaseName;
    private final String schemaName;
    private final String tableName;
    private final String numberedFolder;
    private final String fileName;

    ExportObjectKey(String prefix, String exportTaskId, String databaseName, String schemaName, String tableName, String numberedFolder, String fileName) {
        this.prefix = prefix;
        this.exportTaskId = exportTaskId;
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.numberedFolder = numberedFolder;
        this.fileName = fileName;
    }

    public static ExportObjectKey fromString(String objectKeyString) {
        String[] parts = objectKeyString.split(S3_PATH_DELIMITER);
        if (parts.length < 5) {
            throw new IllegalArgumentException("Export object key is not valid: " + objectKeyString);
        }
        String prefix = Arrays.stream(parts, 0, parts.length - 5).collect(Collectors.joining(S3_PATH_DELIMITER));
        String exportTaskId = parts[parts.length - 5];
        String databaseName = parts[parts.length - 4];
        String fullTableName = parts[parts.length - 3];
        String schemaName = fullTableName.split("\\.")[0];
        String tableName = fullTableName.split("\\.")[1];
        String numberedFolder = parts[parts.length - 2];
        String fileName = parts[parts.length - 1];
        return new ExportObjectKey(prefix, exportTaskId, databaseName, schemaName, tableName, numberedFolder, fileName);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getExportTaskId() {
        return this.exportTaskId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNumberedFolder() {
        return this.numberedFolder;
    }

    public String getFileName() {
        return this.fileName;
    }
}

