/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Node {
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="keyAttributes")
    private final KeyAttributes keyAttributes;
    @JsonProperty(value="groupByAttributes")
    private final Map<String, String> groupByAttributes;

    public Node(String type, KeyAttributes keyAttributes) {
        this.type = type;
        this.keyAttributes = keyAttributes;
        this.groupByAttributes = Collections.emptyMap();
    }

    public Node(String type, KeyAttributes keyAttributes, Map<String, String> groupByAttributes) {
        this.type = type;
        this.keyAttributes = keyAttributes;
        this.groupByAttributes = groupByAttributes != null ? groupByAttributes : Collections.emptyMap();
    }

    public String getType() {
        return this.type;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public Map<String, String> getGroupByAttributes() {
        return this.groupByAttributes;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.type, node.type) && Objects.equals(this.keyAttributes, node.keyAttributes) && Objects.equals(this.groupByAttributes, node.groupByAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.keyAttributes, this.groupByAttributes);
    }

    public String toString() {
        return "Node{type='" + this.type + "', keyAttributes=" + String.valueOf(this.keyAttributes) + ", groupByAttributes=" + String.valueOf(this.groupByAttributes) + "}";
    }

    public static class KeyAttributes {
        @JsonProperty(value="environment")
        private final String environment;
        @JsonProperty(value="name")
        private final String name;

        public KeyAttributes(String environment, String name) {
            this.environment = environment;
            this.name = name;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAttributes that = (KeyAttributes)o;
            return Objects.equals(this.environment, that.environment) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.name);
        }

        public String toString() {
            return "KeyAttributes{environment='" + this.environment + "', name='" + this.name + "'}";
        }
    }
}

