/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otel_apm_service_map;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>otel_apm_service_map</code> processor uses OpenTelemetry data to create APM service map relationships for visualization, generating ServiceDetails and ServiceRemoteDetails events.")
public class OTelApmServiceMapProcessorConfig {
    static final int DEFAULT_WINDOW_DURATION_SECONDS = 60;
    static final String DEFAULT_DB_PATH = "data/otel-apm-service-map/";
    @JsonProperty(value="window_duration")
    @JsonPropertyDescription(value="Represents the fixed time window during which APM service map relationships are evaluated. Supports ISO-8601 duration format (e.g., PT60S, PT1M) or simple integer values (interpreted as seconds).")
    private Duration windowDuration = Duration.ofSeconds(60L);
    @NotEmpty
    @JsonProperty(value="db_path", defaultValue="data/otel-apm-service-map/")
    @JsonPropertyDescription(value="Represents folder path for creating database files storing transient data off heap memorywhen processing APM service-map data.")
    private String dbPath = "data/otel-apm-service-map/";
    @JsonProperty(value="group_by_attributes")
    @JsonPropertyDescription(value="List of OTEL resource attribute names that should be copied into Service.groupByAttributes when present on the span's resource attributes. Only applied to primary Service objects, not dependency services.")
    private List<String> groupByAttributes = Collections.emptyList();

    public Duration getWindowDuration() {
        return this.windowDuration;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public List<String> getGroupByAttributes() {
        return this.groupByAttributes != null ? Collections.unmodifiableList(this.groupByAttributes) : Collections.emptyList();
    }
}

