/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Objects;

public class DynamoStoreSettings {
    private static final Long DEFAULT_PROVISIONED_READ_CAPACITY_UNITS = 10L;
    private static final Long DEFAULT_PROVISIONED_WRITE_CAPACITY_UNITS = 10L;
    private final String tableName;
    private final String region;
    private final String stsRoleArn;
    private final String stsExternalId;
    private final Duration ttl;
    private Long provisionedReadCapacityUnits = DEFAULT_PROVISIONED_READ_CAPACITY_UNITS;
    private Long provisionedWriteCapacityUnits = DEFAULT_PROVISIONED_WRITE_CAPACITY_UNITS;
    private Boolean skipTableCreation = false;

    @JsonCreator
    public DynamoStoreSettings(@JsonProperty(value="table_name") String tableName, @JsonProperty(value="region") String region, @JsonProperty(value="sts_role_arn") String stsRoleArn, @JsonProperty(value="sts_external_id") String stsExternalId, @JsonProperty(value="skip_table_creation") Boolean skipTableCreation, @JsonProperty(value="provisioned_read_capacity_units") Long provisionedReadCapacityUnits, @JsonProperty(value="provisioned_write_capacity_units") Long provisionedWriteCapacityUnits, @JsonProperty(value="ttl") Duration ttl) {
        Objects.requireNonNull(tableName, "table_name is required for dynamo store settings");
        Objects.requireNonNull(region, "region is required for dynamo store settings");
        this.tableName = tableName;
        this.region = region;
        this.stsRoleArn = stsRoleArn;
        this.stsExternalId = stsExternalId;
        this.ttl = ttl;
        if (Objects.nonNull(skipTableCreation)) {
            this.skipTableCreation = skipTableCreation;
        }
        if (Objects.nonNull(provisionedReadCapacityUnits)) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }
        if (Objects.nonNull(provisionedWriteCapacityUnits)) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStsRoleArn() {
        return this.stsRoleArn;
    }

    public String getStsExternalId() {
        return this.stsExternalId;
    }

    public Long getProvisionedReadCapacityUnits() {
        return this.provisionedReadCapacityUnits;
    }

    public Long getProvisionedWriteCapacityUnits() {
        return this.provisionedWriteCapacityUnits;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public Boolean skipTableCreation() {
        return this.skipTableCreation;
    }
}

