/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternMatcher;
import com.google.inject.servlet.UriPatternType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;

class ServletsModuleBuilder {
    private final Set<String> servletUris = Sets.newHashSet();
    private final Binder binder;

    public ServletsModuleBuilder(Binder binder) {
        this.binder = binder;
    }

    public ServletModule.ServletKeyBindingBuilder serve(List<String> urlPatterns) {
        return new ServletKeyBindingBuilderImpl(this.parsePatterns(UriPatternType.SERVLET, urlPatterns));
    }

    public ServletModule.ServletKeyBindingBuilder serveRegex(List<String> regexes) {
        return new ServletKeyBindingBuilderImpl(this.parsePatterns(UriPatternType.REGEX, regexes));
    }

    private List<UriPatternMatcher> parsePatterns(UriPatternType type, List<String> patterns) {
        ArrayList<UriPatternMatcher> patternMatchers = new ArrayList<UriPatternMatcher>();
        for (String pattern : patterns) {
            if (!this.servletUris.add(pattern)) {
                this.binder.skipSources(new Class[]{ServletModule.class, ServletsModuleBuilder.class}).addError("More than one servlet was mapped to the same URI pattern: " + pattern, new Object[0]);
                continue;
            }
            UriPatternMatcher matcher = null;
            try {
                matcher = UriPatternType.get(type, pattern);
            }
            catch (IllegalArgumentException iae) {
                this.binder.skipSources(new Class[]{ServletModule.class, ServletsModuleBuilder.class}).addError("%s", new Object[]{iae.getMessage()});
            }
            if (matcher == null) continue;
            patternMatchers.add(matcher);
        }
        return patternMatchers;
    }

    class ServletKeyBindingBuilderImpl
    implements ServletModule.ServletKeyBindingBuilder {
        private final List<UriPatternMatcher> uriPatterns;

        private ServletKeyBindingBuilderImpl(List<UriPatternMatcher> uriPatterns) {
            this.uriPatterns = uriPatterns;
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey) {
            this.with((Key<? extends HttpServlet>)Key.get(servletKey));
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey) {
            this.with(servletKey, new HashMap<String, String>());
        }

        @Override
        public void with(HttpServlet servlet) {
            this.with(servlet, new HashMap<String, String>());
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with((Key<? extends HttpServlet>)Key.get(servletKey), initParams);
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(servletKey, initParams, null);
        }

        private void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams, HttpServlet servletInstance) {
            for (UriPatternMatcher pattern : this.uriPatterns) {
                ServletsModuleBuilder.this.binder.bind(Key.get(ServletDefinition.class, (Annotation)UniqueAnnotations.create())).toProvider((Provider)new ServletDefinition(servletKey, pattern, initParams, servletInstance));
            }
        }

        @Override
        public void with(HttpServlet servlet, Map<String, String> initParams) {
            Key servletKey = Key.get(HttpServlet.class, (Annotation)UniqueAnnotations.create());
            ServletsModuleBuilder.this.binder.bind(servletKey).toInstance((Object)servlet);
            this.with((Key<? extends HttpServlet>)servletKey, initParams, servlet);
        }
    }
}

