/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.base;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerClient;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.SaasSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.scheduler.LeaderScheduler;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.PaginationCrawlerWorkerProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PaginationCrawler
implements Crawler<PaginationCrawlerWorkerProgressState> {
    private static final Logger log = LoggerFactory.getLogger(PaginationCrawler.class);
    private static final int batchSize = 50;
    private static final String PAGINATION_WORKER_PARTITIONS_CREATED = "paginationWorkerPartitionsCreated";
    private static final String INVALID_PAGINATION_ITEMS = "invalidPaginationItems";
    private final Timer crawlingTimer;
    private final CrawlerClient client;
    private final Counter parititionsCreatedCounter;
    private final Counter invalidPaginationItemsCounter;

    public PaginationCrawler(CrawlerClient client, PluginMetrics pluginMetrics) {
        this.client = client;
        this.crawlingTimer = pluginMetrics.timer("crawlingTime");
        this.parititionsCreatedCounter = pluginMetrics.counter(PAGINATION_WORKER_PARTITIONS_CREATED);
        this.invalidPaginationItemsCounter = pluginMetrics.counter(INVALID_PAGINATION_ITEMS);
    }

    @Override
    public Instant crawl(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator) {
        long startTime = System.currentTimeMillis();
        Instant lastLeaderSavedInstant = Instant.now();
        LeaderProgressState leaderProgressState = leaderPartition.getProgressState().get();
        Instant lastPollTime = leaderProgressState.getLastPollTime();
        Iterator<ItemInfo> itemInfoIterator = this.client.listItems(lastPollTime);
        Instant latestModifiedTime = lastPollTime;
        log.info("Starting to crawl the source with lastPollTime: {}", (Object)lastPollTime);
        do {
            ArrayList<ItemInfo> itemInfoList = new ArrayList<ItemInfo>();
            for (int i = 0; i < 50 && itemInfoIterator.hasNext(); ++i) {
                ItemInfo nextItem = itemInfoIterator.next();
                if (nextItem == null) {
                    log.info("Unexpected encounter of a null item.");
                    this.invalidPaginationItemsCounter.increment();
                    continue;
                }
                itemInfoList.add(nextItem);
                if (!nextItem.getLastModifiedAt().isAfter(latestModifiedTime)) continue;
                latestModifiedTime = nextItem.getLastModifiedAt();
            }
            this.createPartition(itemInfoList, coordinator);
            Instant currentTimeInstance = Instant.now();
            if (Duration.between(lastLeaderSavedInstant, currentTimeInstance).toMinutes() < 1L) continue;
            this.updateLeaderProgressState(leaderPartition, latestModifiedTime, coordinator);
            lastLeaderSavedInstant = currentTimeInstance;
        } while (itemInfoIterator.hasNext());
        this.updateLeaderProgressState(leaderPartition, latestModifiedTime, coordinator);
        long crawlTimeMillis = System.currentTimeMillis() - startTime;
        log.debug("Crawling completed in {} ms", (Object)crawlTimeMillis);
        this.crawlingTimer.record(crawlTimeMillis, TimeUnit.MILLISECONDS);
        return latestModifiedTime;
    }

    @Override
    public void executePartition(PaginationCrawlerWorkerProgressState state, Buffer<Record<Event>> buffer, AcknowledgementSet acknowledgementSet) {
        this.client.executePartition(state, buffer, acknowledgementSet);
    }

    private void updateLeaderProgressState(LeaderPartition leaderPartition, Instant updatedPollTime, EnhancedSourceCoordinator coordinator) {
        LeaderProgressState leaderProgressState = leaderPartition.getProgressState().get();
        Instant oldPollTime = leaderProgressState.getLastPollTime();
        leaderProgressState.setLastPollTime(updatedPollTime);
        leaderPartition.setLeaderProgressState(leaderProgressState);
        coordinator.saveProgressStateForPartition((EnhancedSourcePartition)leaderPartition, LeaderScheduler.DEFAULT_EXTEND_LEASE_MINUTES);
        log.debug("Updated leader progress state: old lastPollTime={}, new lastPollTime={}", (Object)oldPollTime, (Object)updatedPollTime);
    }

    private void createPartition(List<ItemInfo> itemInfoList, EnhancedSourceCoordinator coordinator) {
        if (itemInfoList.isEmpty()) {
            return;
        }
        ItemInfo itemInfo = itemInfoList.get(0);
        String partitionKey = itemInfo.getPartitionKey();
        List<String> itemIds = itemInfoList.stream().map(ItemInfo::getId).collect(Collectors.toList());
        PaginationCrawlerWorkerProgressState state = new PaginationCrawlerWorkerProgressState();
        state.setKeyAttributes(itemInfo.getKeyAttributes());
        state.setItemIds(itemIds);
        state.setExportStartTime(Instant.now());
        state.setLoadedItems(itemInfoList.size());
        SaasSourcePartition sourcePartition = new SaasSourcePartition(state, partitionKey);
        coordinator.createPartition((EnhancedSourcePartition)sourcePartition);
        this.parititionsCreatedCounter.increment();
    }
}

