/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.base;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.UsesEnhancedSourceCoordination;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PluginExecutorServiceProvider;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.PartitionFactory;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.scheduler.LeaderScheduler;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.scheduler.WorkerScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrawlerSourcePlugin
implements Source<Record<Event>>,
UsesEnhancedSourceCoordination {
    private static final Logger log = LoggerFactory.getLogger(CrawlerSourcePlugin.class);
    private EnhancedSourceCoordinator coordinator;
    private final PluginMetrics pluginMetrics;
    private final PluginFactory pluginFactory;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final ExecutorService executorService;
    private final CrawlerSourceConfig sourceConfig;
    private final Crawler crawler;
    private final String sourcePluginName;

    public CrawlerSourcePlugin(String sourcePluginName, PluginMetrics pluginMetrics, CrawlerSourceConfig sourceConfig, PluginFactory pluginFactory, AcknowledgementSetManager acknowledgementSetManager, Crawler crawler, PluginExecutorServiceProvider executorServiceProvider) {
        log.debug("Creating {} Source Plugin", (Object)sourcePluginName);
        this.sourcePluginName = sourcePluginName;
        this.pluginMetrics = pluginMetrics;
        this.sourceConfig = sourceConfig;
        this.pluginFactory = pluginFactory;
        this.crawler = crawler;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.executorService = executorServiceProvider.get();
    }

    protected abstract LeaderProgressState createLeaderProgressState();

    public void start(Buffer<Record<Event>> buffer) {
        Objects.requireNonNull(this.coordinator);
        log.info("Starting {} Source Plugin", (Object)this.sourcePluginName);
        LeaderPartition leaderPartition = new LeaderPartition(this.createLeaderProgressState());
        boolean isPartitionCreated = this.coordinator.createPartition((EnhancedSourcePartition)leaderPartition);
        log.debug("Leader partition creation status: {}", (Object)isPartitionCreated);
        LeaderScheduler leaderScheduler = new LeaderScheduler(this.coordinator, this.crawler);
        leaderScheduler.setLeaseInterval(this.sourceConfig.getLeaseInterval());
        this.executorService.submit(leaderScheduler);
        for (int i = 0; i < this.sourceConfig.getNumberOfWorkers(); ++i) {
            WorkerScheduler workerScheduler = new WorkerScheduler(this.sourcePluginName, buffer, this.coordinator, this.sourceConfig, this.crawler, this.pluginMetrics, this.acknowledgementSetManager);
            this.executorService.submit(new Thread(workerScheduler));
        }
    }

    public void stop() {
        log.info("Stop Source Connector");
        this.executorService.shutdownNow();
    }

    public void setEnhancedSourceCoordinator(EnhancedSourceCoordinator sourceCoordinator) {
        this.coordinator = sourceCoordinator;
        this.coordinator.initialize();
    }

    public Function<SourcePartitionStoreItem, EnhancedSourcePartition> getPartitionFactory() {
        return new PartitionFactory();
    }

    public ByteDecoder getDecoder() {
        return super.getDecoder();
    }
}

