/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;

@SdkPublicApi
@ThreadSafe
public final class StaticAttribute<T, R> {
    private final ImmutableAttribute<T, T, R> delegateAttribute;

    private StaticAttribute(Builder<T, R> builder) {
        this.delegateAttribute = ((Builder)builder).delegateBuilder.build();
    }

    public static <T, R> Builder<T, R> builder(Class<T> itemClass, EnhancedType<R> attributeType) {
        return new Builder(EnhancedType.of(itemClass), attributeType);
    }

    public static <T, R> Builder<T, R> builder(EnhancedType<T> itemType, EnhancedType<R> attributeType) {
        return new Builder(itemType, attributeType);
    }

    public static <T, R> Builder<T, R> builder(Class<T> itemClass, Class<R> attributeClass) {
        return new Builder(EnhancedType.of(itemClass), EnhancedType.of(attributeClass));
    }

    public String name() {
        return this.delegateAttribute.name();
    }

    public Function<T, R> getter() {
        return this.delegateAttribute.getter();
    }

    public BiConsumer<T, R> setter() {
        return this.delegateAttribute.setter();
    }

    public Collection<StaticAttributeTag> tags() {
        return this.delegateAttribute.tags();
    }

    public EnhancedType<R> type() {
        return this.delegateAttribute.type();
    }

    public AttributeConverter<R> attributeConverter() {
        return this.delegateAttribute.attributeConverter();
    }

    public Builder<T, R> toBuilder() {
        return new Builder(this.delegateAttribute.toBuilder());
    }

    ImmutableAttribute<T, T, R> toImmutableAttribute() {
        return this.delegateAttribute;
    }

    @NotThreadSafe
    public static final class Builder<T, R> {
        private final ImmutableAttribute.Builder<T, T, R> delegateBuilder;

        private Builder(EnhancedType<T> itemType, EnhancedType<R> type) {
            this.delegateBuilder = ImmutableAttribute.builder(itemType, itemType, type);
        }

        private Builder(ImmutableAttribute.Builder<T, T, R> delegateBuilder) {
            this.delegateBuilder = delegateBuilder;
        }

        public Builder<T, R> name(String name) {
            this.delegateBuilder.name(name);
            return this;
        }

        public Builder<T, R> getter(Function<T, R> getter) {
            this.delegateBuilder.getter(getter);
            return this;
        }

        public Builder<T, R> setter(BiConsumer<T, R> setter) {
            this.delegateBuilder.setter(setter);
            return this;
        }

        public Builder<T, R> tags(Collection<StaticAttributeTag> tags) {
            this.delegateBuilder.tags(tags);
            return this;
        }

        public Builder<T, R> tags(StaticAttributeTag ... tags) {
            this.delegateBuilder.tags(tags);
            return this;
        }

        public Builder<T, R> addTag(StaticAttributeTag tag) {
            this.delegateBuilder.addTag(tag);
            return this;
        }

        public Builder<T, R> attributeConverter(AttributeConverter<R> attributeConverter) {
            this.delegateBuilder.attributeConverter(attributeConverter);
            return this;
        }

        public StaticAttribute<T, R> build() {
            return new StaticAttribute(this);
        }
    }
}

