/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;

class GenericTypeOfOperator
implements Operator<Boolean> {
    private final int symbol;
    private final String displayName;
    private final BiPredicate<Object, Object> operation;

    public GenericTypeOfOperator(int symbol, BiPredicate<Object, Object> operation) {
        this.symbol = symbol;
        this.displayName = DataPrepperExpressionParser.VOCABULARY.getDisplayName(symbol);
        this.operation = operation;
    }

    @Override
    public boolean isBooleanOperator() {
        return true;
    }

    @Override
    public boolean shouldEvaluate(RuleContext ctx) {
        return ctx.getRuleIndex() == 14;
    }

    @Override
    public int getSymbol() {
        return this.symbol;
    }

    @Override
    public Boolean evaluate(Object ... args) {
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)(this.displayName + " requires operands length to be 2."));
        return this.operation.test(args[0], args[1]);
    }
}

