/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otellogs.http;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.rpc.RetryInfo;
import com.google.rpc.Status;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.micrometer.core.instrument.Counter;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.RetryInfoCalculator;
import org.opensearch.dataprepper.exceptions.BadRequestException;
import org.opensearch.dataprepper.exceptions.BufferWriteException;
import org.opensearch.dataprepper.exceptions.RequestCancelledException;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.SizeOverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExceptionHandler
implements ExceptionHandlerFunction {
    private static final Logger LOG = LoggerFactory.getLogger(HttpExceptionHandler.class);
    static final String ARMERIA_REQUEST_TIMEOUT_MESSAGE = "Timeout waiting for request to be served. This is usually due to the buffer being full.";
    public static final String REQUEST_TIMEOUTS = "requestTimeouts";
    public static final String BAD_REQUESTS = "badRequests";
    public static final String REQUESTS_TOO_LARGE = "requestsTooLarge";
    public static final String INTERNAL_SERVER_ERROR = "internalServerError";
    private final Counter requestTimeoutsCounter;
    private final Counter badRequestsCounter;
    private final Counter requestsTooLargeCounter;
    private final Counter internalServerErrorCounter;
    private final RetryInfoCalculator retryInfoCalculator;

    public HttpExceptionHandler(PluginMetrics pluginMetrics, Duration retryInfoMinDelay, Duration retryInfoMaxDelay) {
        this.requestTimeoutsCounter = pluginMetrics.counter(REQUEST_TIMEOUTS);
        this.badRequestsCounter = pluginMetrics.counter(BAD_REQUESTS);
        this.requestsTooLargeCounter = pluginMetrics.counter(REQUESTS_TOO_LARGE);
        this.internalServerErrorCounter = pluginMetrics.counter(INTERNAL_SERVER_ERROR);
        this.retryInfoCalculator = new RetryInfoCalculator(retryInfoMinDelay, retryInfoMaxDelay);
    }

    public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable e) {
        Throwable exceptionCause = e instanceof BufferWriteException ? e.getCause() : (e instanceof HttpStatusException ? e.getCause() : e);
        StatusHolder statusHolder = this.createStatus(exceptionCause);
        try {
            JsonFormat.TypeRegistry typeRegistry = JsonFormat.TypeRegistry.newBuilder().add(RetryInfo.getDescriptor()).build();
            JsonFormat.Printer printer = JsonFormat.printer().usingTypeRegistry(typeRegistry);
            return HttpResponse.of((HttpStatus)statusHolder.getHttpStatus(), (MediaType)MediaType.JSON, (String)printer.print((MessageOrBuilder)statusHolder.getStatus()));
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new RuntimeException(ipbe);
        }
    }

    private StatusHolder createStatus(Throwable e) {
        if (e instanceof RequestTimeoutException || e instanceof TimeoutException) {
            this.requestTimeoutsCounter.increment();
            return new StatusHolder(this.createStatus(e, Status.Code.RESOURCE_EXHAUSTED), this.createHttpStatusFromProtoBufStatus(Status.Code.RESOURCE_EXHAUSTED));
        }
        if (e instanceof SizeOverflowException || e instanceof ContentTooLargeException) {
            this.requestsTooLargeCounter.increment();
            return new StatusHolder(this.createStatus(e, Status.Code.RESOURCE_EXHAUSTED), this.createHttpStatusFromProtoBufStatus(Status.Code.RESOURCE_EXHAUSTED));
        }
        if (e instanceof BadRequestException) {
            this.badRequestsCounter.increment();
            return new StatusHolder(this.createStatus(e, Status.Code.INVALID_ARGUMENT), this.createHttpStatusFromProtoBufStatus(Status.Code.INVALID_ARGUMENT));
        }
        if (e instanceof StatusRuntimeException && (e.getMessage().contains("Invalid protobuf byte sequence") || e.getMessage().contains("Can't decode compressed frame"))) {
            this.badRequestsCounter.increment();
            return new StatusHolder(this.createStatus(e, Status.Code.INVALID_ARGUMENT), this.createHttpStatusFromProtoBufStatus(Status.Code.INVALID_ARGUMENT));
        }
        if (e instanceof RequestCancelledException) {
            this.requestTimeoutsCounter.increment();
            return new StatusHolder(this.createStatus(e, Status.Code.CANCELLED), this.createHttpStatusFromProtoBufStatus(Status.Code.CANCELLED));
        }
        LOG.error("Unexpected exception handling http request", e);
        this.internalServerErrorCounter.increment();
        return new StatusHolder(this.createStatus(e, Status.Code.INTERNAL), this.createHttpStatusFromProtoBufStatus(Status.Code.INTERNAL));
    }

    private HttpStatus createHttpStatusFromProtoBufStatus(Status.Code status) {
        if (status == Status.Code.RESOURCE_EXHAUSTED) {
            return HttpStatus.INSUFFICIENT_STORAGE;
        }
        if (status == Status.Code.INVALID_ARGUMENT) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    private Status createStatus(Throwable e, Status.Code code) {
        Status.Builder builder = Status.newBuilder().setCode(code.value());
        if (e instanceof RequestTimeoutException) {
            builder.setMessage(ARMERIA_REQUEST_TIMEOUT_MESSAGE);
        } else {
            builder.setMessage(e.getMessage() == null ? code.name() : e.getMessage());
        }
        if (code == Status.Code.RESOURCE_EXHAUSTED) {
            builder.addDetails(Any.pack((Message)this.retryInfoCalculator.createRetryInfo()));
        }
        return builder.build();
    }

    private static class StatusHolder {
        private final HttpStatus httpStatus;
        private final Status status;

        public StatusHolder(Status status, HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            this.status = status;
        }

        public HttpStatus getHttpStatus() {
            return this.httpStatus;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

