/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>select_entries</code> processor selects entries from an event.")
public class SelectEntriesProcessorConfig {
    @JsonProperty(value="include_keys")
    @JsonPropertyDescription(value="A list of keys to be selected from an event.")
    private List<String> includeKeys;
    @JsonProperty(value="include_keys_regex")
    @JsonPropertyDescription(value="A list of regex patterns to match keys be selected from an event.")
    private List<String> includeKeysRegex;
    @JsonIgnore
    private List<Pattern> includeKeysRegexPatterns;
    @JsonIgnore
    private String includeKeysRegexPointer;
    @JsonProperty(value="select_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"</code>, that will be evaluated to determine whether the processor will be run on the event. Default is <code>null</code>. All events will be processed unless otherwise stated.")
    @ExampleValues(value={@ExampleValues.Example(value="/some-key == test", description="Only runs the select_entries processor on the Event if some_key is 'test'.")})
    private String selectWhen;

    public List<String> getIncludeKeys() {
        return this.includeKeys;
    }

    public List<Pattern> getIncludeKeysRegex() {
        return this.includeKeysRegexPatterns;
    }

    public String getIncludeKeysRegexPointer() {
        return this.includeKeysRegexPointer;
    }

    public String getSelectWhen() {
        return this.selectWhen;
    }

    private void setIncludeKeysRegex() {
        this.includeKeysRegexPatterns = this.includeKeysRegex.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @AssertTrue(message="At least one of include_keys and include_keys_regex is required.")
    @AssertTrue(message="At least one of include_keys and include_keys_regex is required.") boolean isValidIncludeKeys() {
        return this.includeKeys != null && !this.includeKeys.isEmpty() || this.includeKeysRegex != null && !this.includeKeysRegex.isEmpty();
    }

    @AssertTrue(message="Invalid regex pattern found in include_keys_regex.")
    @AssertTrue(message="Invalid regex pattern found in include_keys_regex.") boolean isValidIncludeKeysRegex() {
        if (this.includeKeysRegex != null && !this.includeKeysRegex.isEmpty()) {
            try {
                this.setIncludeKeysRegex();
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        return true;
    }
}

