/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import io.micrometer.core.instrument.Counter;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.SizeOverflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestExceptionHandler
implements ExceptionHandlerFunction {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestExceptionHandler.class);
    static final String ARMERIA_REQUEST_TIMEOUT_MESSAGE = "Timeout waiting for request to be served. This is usually due to the buffer being full.";
    public static final String REQUEST_TIMEOUTS = "requestTimeouts";
    public static final String BAD_REQUESTS = "badRequests";
    public static final String REQUESTS_TOO_LARGE = "requestsTooLarge";
    public static final String INTERNAL_SERVER_ERROR = "internalServerError";
    private final Counter requestTimeoutsCounter;
    private final Counter badRequestsCounter;
    private final Counter requestsTooLargeCounter;
    private final Counter internalServerErrorCounter;

    public HttpRequestExceptionHandler(PluginMetrics pluginMetrics) {
        this.requestTimeoutsCounter = pluginMetrics.counter(REQUEST_TIMEOUTS);
        this.badRequestsCounter = pluginMetrics.counter(BAD_REQUESTS);
        this.requestsTooLargeCounter = pluginMetrics.counter(REQUESTS_TOO_LARGE);
        this.internalServerErrorCounter = pluginMetrics.counter(INTERNAL_SERVER_ERROR);
    }

    public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
        HttpStatus status = this.handleException(cause);
        String message = cause instanceof RequestTimeoutException ? ARMERIA_REQUEST_TIMEOUT_MESSAGE : (cause.getMessage() == null ? status.reasonPhrase() : cause.getMessage());
        return HttpResponse.of((HttpStatus)status, (MediaType)MediaType.ANY_TYPE, (String)message);
    }

    private HttpStatus handleException(Throwable e) {
        if (e instanceof HttpStatusException) {
            return ((HttpStatusException)e).httpStatus();
        }
        if (e instanceof IOException) {
            this.badRequestsCounter.increment();
            return HttpStatus.BAD_REQUEST;
        }
        if (e instanceof TimeoutException || e instanceof RequestTimeoutException) {
            this.requestTimeoutsCounter.increment();
            return HttpStatus.REQUEST_TIMEOUT;
        }
        if (e instanceof SizeOverflowException) {
            this.requestsTooLargeCounter.increment();
            return HttpStatus.REQUEST_ENTITY_TOO_LARGE;
        }
        if (e instanceof IllegalArgumentException) {
            this.badRequestsCounter.increment();
            return HttpStatus.BAD_REQUEST;
        }
        this.internalServerErrorCounter.increment();
        LOG.error("Unexpected exception handling HTTP request", e);
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

