/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.client;

import com.mongodb.client.model.Filters;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDateTime;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BsonHelper {
    static final String PARTITION_FORMAT = "%s-%s";
    private static final String PARTITION_SPLITTER = "-";
    private static final String NUMBER_TYPE = "number";
    public static final String MAX_KEY = "MaxKey";
    public static final String UNKNOWN_TYPE = "UNKNOWN";
    private static final List<String> RANGE_TYPE_ORDER = Arrays.asList("number", "java.lang.String", "org.bson.Document", "org.bson.types.Binary", "org.bson.types.ObjectId", "java.lang.Boolean", "java.util.Date", "org.bson.BsonDateTime", "org.bson.BsonTimestamp", "MaxKey");
    private static final Function<Object, Bson> GT_FUNCTION = a -> Filters.gt((String)DOCUMENTDB_ID_FIELD_NAME, (Object)a);
    private static final Function<Object, Bson> GTE_FUNCTION = a -> Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)a);
    private static final Function<Object, Bson> LTE_FUNCTION = a -> Filters.lte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)a);
    private static final String REGEX_PATTERN = "pattern";
    private static final String REGEX_OPTIONS = "options";
    public static final String DOCUMENTDB_ID_FIELD_NAME = "_id";
    public static final JsonWriterSettings JSON_WRITER_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).objectIdConverter((value, writer) -> writer.writeString(value.toHexString())).binaryConverter((value, writer) -> writer.writeString(BsonHelper.getStringFromBsonBinary(value))).dateTimeConverter((value, writer) -> writer.writeNumber(String.valueOf(value))).decimal128Converter((value, writer) -> writer.writeString(value.bigDecimalValue().toPlainString())).maxKeyConverter((value, writer) -> writer.writeNull()).minKeyConverter((value, writer) -> writer.writeNull()).regularExpressionConverter((value, writer) -> {
        writer.writeStartObject();
        writer.writeString(REGEX_PATTERN, value.getPattern());
        writer.writeString(REGEX_OPTIONS, value.getOptions());
        writer.writeEndObject();
    }).timestampConverter((value, writer) -> writer.writeNumber(String.valueOf(value.getTime()))).undefinedConverter((value, writer) -> writer.writeNull()).build();

    private static String getStringFromBsonBinary(BsonBinary bsonBinary) {
        if (bsonBinary.getType() == BsonBinarySubType.UUID_STANDARD.getValue()) {
            return bsonBinary.asUuid().toString();
        }
        return Base64.getEncoder().encodeToString(bsonBinary.getData());
    }

    public static String getPartitionStringFromMongoDBId(Object id, String className) {
        switch (className) {
            case "org.bson.Document": {
                return ((Document)id).toJson(JSON_WRITER_SETTINGS);
            }
            case "org.bson.types.Binary": {
                byte type = ((Binary)id).getType();
                byte[] data = ((Binary)id).getData();
                String typeString = String.valueOf(type);
                String dataString = Base64.getEncoder().encodeToString(data);
                return String.format(PARTITION_FORMAT, typeString, dataString);
            }
            case "java.util.Date": {
                return String.valueOf(((Date)id).getTime());
            }
            case "org.bson.BsonDateTime": {
                return String.valueOf(((BsonDateTime)id).getValue());
            }
            case "org.bson.BsonTimestamp": {
                int time = ((BsonTimestamp)id).getTime();
                int inc = ((BsonTimestamp)id).getInc();
                return String.format(PARTITION_FORMAT, time, inc);
            }
            case "org.bson.types.Code": {
                return ((Code)id).getCode();
            }
            case "org.bson.types.Decimal128": {
                return ((Decimal128)id).bigDecimalValue().toPlainString();
            }
        }
        return id.toString();
    }

    private static Bson buildAndQuery(String gte, String lte, String gteClassName, String lteClassName) {
        return Filters.and((Bson[])new Bson[]{BsonHelper.buildQuery(GTE_FUNCTION, gte, gteClassName), BsonHelper.buildQuery(LTE_FUNCTION, lte, lteClassName)});
    }

    private static Bson buildQuery(Function<Object, Bson> function, String value, String className) {
        switch (className) {
            case "java.lang.Integer": {
                return function.apply(Integer.parseInt(value));
            }
            case "java.lang.Long": {
                return function.apply(Long.parseLong(value));
            }
            case "java.lang.Double": {
                return function.apply(Double.parseDouble(value));
            }
            case "org.bson.types.Decimal128": {
                return function.apply(Decimal128.parse((String)value));
            }
            case "java.lang.String": {
                return function.apply(value);
            }
            case "org.bson.types.Symbol": {
                return function.apply(new Symbol(value));
            }
            case "org.bson.Document": {
                return function.apply(Document.parse((String)value));
            }
            case "org.bson.types.Binary": {
                String[] binaryString = value.split(PARTITION_SPLITTER, 2);
                return function.apply(new Binary(Byte.parseByte(binaryString[0]), Base64.getDecoder().decode(binaryString[1])));
            }
            case "org.bson.types.ObjectId": {
                return function.apply(new ObjectId(value));
            }
            case "java.lang.Boolean": {
                return function.apply(Boolean.parseBoolean(value));
            }
            case "java.util.Date": 
            case "org.bson.BsonDateTime": {
                return function.apply(new BsonDateTime(Long.parseLong(value)));
            }
            case "org.bson.BsonTimestamp": {
                String[] timestampString = value.split(PARTITION_SPLITTER, 2);
                return function.apply(new BsonTimestamp(Integer.parseInt(timestampString[0]), Integer.parseInt(timestampString[1])));
            }
            case "org.bson.types.Code": {
                return function.apply(new Code(value));
            }
        }
        throw new RuntimeException("Unexpected _id class not supported: " + className);
    }

    private static boolean isClassNumber(String className) {
        return className.equals("java.lang.Integer") || className.equals("java.lang.Long") || className.equals("java.lang.Double") || className.equals("org.bson.types.Decimal128");
    }

    public static Bson buildGtQuery(String greaterThan, String gtClassName, String lteClassName) {
        Bson bsonQuery = BsonHelper.buildQuery(GT_FUNCTION, greaterThan, gtClassName);
        return BsonHelper.buildSortOrderQuery(bsonQuery, gtClassName, lteClassName);
    }

    private static Bson buildGteQuery(String greaterThanEquals, String gteClassName, String lteClassName) {
        Bson bsonQuery = BsonHelper.buildQuery(GTE_FUNCTION, greaterThanEquals, gteClassName);
        return BsonHelper.buildSortOrderQuery(bsonQuery, gteClassName, lteClassName);
    }

    private static Bson buildSortOrderQuery(Bson bsonQuery, String gtClassName, String lteClassName) {
        int prev_i = BsonHelper.isClassNumber(gtClassName) ? RANGE_TYPE_ORDER.indexOf(NUMBER_TYPE) : RANGE_TYPE_ORDER.indexOf(gtClassName);
        int curr_i = BsonHelper.isClassNumber(lteClassName) ? RANGE_TYPE_ORDER.indexOf(NUMBER_TYPE) : RANGE_TYPE_ORDER.indexOf(lteClassName);
        block30: for (int i = prev_i + 1; i < curr_i; ++i) {
            String className;
            switch (className = RANGE_TYPE_ORDER.get(i)) {
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Double": 
                case "org.bson.types.Decimal128": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new BsonInt32(0))});
                    continue block30;
                }
                case "java.lang.String": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new BsonString(""))});
                    continue block30;
                }
                case "org.bson.types.Symbol": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new Symbol(""))});
                    continue block30;
                }
                case "org.bson.Document": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new Document())});
                    continue block30;
                }
                case "org.bson.types.ObjectId": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new BsonObjectId(new ObjectId("000000000000000000000000")))});
                    continue block30;
                }
                case "java.lang.Boolean": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.in((String)DOCUMENTDB_ID_FIELD_NAME, (Object[])new Boolean[]{true, false})});
                    continue block30;
                }
                case "org.bson.types.Binary": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new BsonBinary(new byte[0]))});
                    continue block30;
                }
                case "java.util.Date": 
                case "org.bson.BsonDateTime": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new BsonDateTime(0L))});
                    continue block30;
                }
                case "org.bson.BsonTimestamp": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new BsonTimestamp(0L))});
                    continue block30;
                }
                case "org.bson.types.Code": {
                    bsonQuery = Filters.or((Bson[])new Bson[]{bsonQuery, Filters.gte((String)DOCUMENTDB_ID_FIELD_NAME, (Object)new Code(""))});
                    continue block30;
                }
                case "MaxKey": {
                    continue block30;
                }
                default: {
                    throw new RuntimeException("Unexpected _id class not supported: " + className);
                }
            }
        }
        return bsonQuery;
    }

    public static Bson buildQuery(String gte, String lte, String gteClassName, String lteClassName) {
        if (gteClassName.equals(lteClassName) || BsonHelper.isClassNumber(gteClassName) && BsonHelper.isClassNumber(lteClassName)) {
            return BsonHelper.buildAndQuery(gte, lte, gteClassName, lteClassName);
        }
        Bson bsonQuery = BsonHelper.buildGteQuery(gte, gteClassName, lteClassName);
        return Filters.or((Bson[])new Bson[]{bsonQuery, BsonHelper.buildQuery(LTE_FUNCTION, lte, lteClassName)});
    }
}

