/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OAuthConfig {
    private static final String OAUTH_LOGIN_GRANT_TYPE = "refresh_token";
    private static final String OAUTH_LOGIN_SCOPE = "kafka";
    private static final String OAUTH_SASL_MECHANISM = "OAUTHBEARER";
    private static final String OAUTH_SECURITY_PROTOCOL = "SASL_PLAINTEXT";
    private static final String OAUTH_SASL_LOGIN_CALLBACK_HANDLER_CLASS = "org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerLoginCallbackHandler";
    private static final String OAUTH_INTROSPECT_ENDPOINT = "/oauth2/default/v1/introspect";
    @JsonProperty(value="oauth_client_id")
    private String oauthClientId;
    @JsonProperty(value="oauth_client_secret")
    private String oauthClientSecret;
    @JsonProperty(value="oauth_login_server")
    private String oauthLoginServer;
    @JsonProperty(value="oauth_login_endpoint")
    private String oauthLoginEndpoint;
    @JsonProperty(value="oauth_login_grant_type")
    private String oauthLoginGrantType = "refresh_token";
    @JsonProperty(value="oauth_login_scope")
    private String oauthLoginScope = "kafka";
    @JsonProperty(value="oauth_authorization_token")
    private String oauthAuthorizationToken;
    @JsonProperty(value="oauth_introspect_server")
    private String oauthIntrospectServer = "";
    @JsonProperty(value="oauth_introspect_endpoint")
    private String oauthIntrospectEndpoint = "";
    @JsonProperty(value="oauth_introspect_authorization_token")
    private String oauthIntrospectAuthorizationToken;
    @JsonProperty(value="oauth_token_endpoint_url")
    private String oauthTokenEndpointURL;
    @JsonProperty(value="oauth_sasl_mechanism")
    private String oauthSaslMechanism = "OAUTHBEARER";
    @JsonProperty(value="oauth_security_protocol")
    private String oauthSecurityProtocol = "SASL_PLAINTEXT";
    @JsonProperty(value="oauth_sasl_login_callback_handler_class")
    private String oauthSaslLoginCallbackHandlerClass = "org.apache.kafka.common.security.oauthbearer.secured.OAuthBearerLoginCallbackHandler";
    @JsonProperty(value="oauth_jwks_endpoint_url")
    private String oauthJwksEndpointURL = "";
    @JsonProperty(value="extension_logicalCluster")
    private String extensionLogicalCluster;
    @JsonProperty(value="extension_identityPoolId")
    private String extensionIdentityPoolId;

    public String getOauthAuthorizationToken() {
        return this.oauthAuthorizationToken;
    }

    public String getOauthIntrospectAuthorizationToken() {
        return this.oauthIntrospectAuthorizationToken;
    }

    public String getExtensionLogicalCluster() {
        return this.extensionLogicalCluster;
    }

    public String getExtensionIdentityPoolId() {
        return this.extensionIdentityPoolId;
    }

    public String getOauthJwksEndpointURL() {
        return this.oauthJwksEndpointURL;
    }

    public String getOauthSaslMechanism() {
        return this.oauthSaslMechanism;
    }

    public String getOauthSecurityProtocol() {
        return this.oauthSecurityProtocol;
    }

    public String getOauthSaslLoginCallbackHandlerClass() {
        return this.oauthSaslLoginCallbackHandlerClass;
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public String getOauthTokenEndpointURL() {
        return this.oauthTokenEndpointURL;
    }

    public String getOauthLoginServer() {
        return this.oauthLoginServer;
    }

    public void setOauthLoginServer(String oauthLoginServer) {
        this.oauthLoginServer = oauthLoginServer;
    }

    public String getOauthLoginEndpoint() {
        return this.oauthLoginEndpoint;
    }

    public void setOauthLoginEndpoint(String oauthLoginEndpoint) {
        this.oauthLoginEndpoint = oauthLoginEndpoint;
    }

    public String getOauthLoginGrantType() {
        return this.oauthLoginGrantType;
    }

    public void setOauthLoginGrantType(String oauthLoginGrantType) {
        this.oauthLoginGrantType = oauthLoginGrantType;
    }

    public String getOauthLoginScope() {
        return this.oauthLoginScope;
    }

    public void setOauthLoginScope(String oauthLoginScope) {
        this.oauthLoginScope = oauthLoginScope;
    }

    public String getOauthIntrospectServer() {
        return this.oauthIntrospectServer;
    }

    public void setOauthIntrospectServer(String oauthIntrospectServer) {
        this.oauthIntrospectServer = oauthIntrospectServer;
    }

    public String getOauthIntrospectEndpoint() {
        if (!this.oauthIntrospectServer.isEmpty() || !this.oauthIntrospectServer.isBlank()) {
            return OAUTH_INTROSPECT_ENDPOINT;
        }
        return this.oauthIntrospectEndpoint;
    }

    public void setOauthIntrospectEndpoint(String oauthIntrospectEndpoint) {
        this.oauthIntrospectEndpoint = oauthIntrospectEndpoint;
    }
}

