/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlueprintRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetBlueprintRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetBlueprintRequest.getter(GetBlueprintRequest::name)).setter(GetBlueprintRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> INCLUDE_BLUEPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeBlueprint").getter(GetBlueprintRequest.getter(GetBlueprintRequest::includeBlueprint)).setter(GetBlueprintRequest.setter(Builder::includeBlueprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeBlueprint").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PARAMETER_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeParameterSpec").getter(GetBlueprintRequest.getter(GetBlueprintRequest::includeParameterSpec)).setter(GetBlueprintRequest.setter(Builder::includeParameterSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeParameterSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INCLUDE_BLUEPRINT_FIELD, INCLUDE_PARAMETER_SPEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBlueprintRequest.memberNameToFieldInitializer();
    private final String name;
    private final Boolean includeBlueprint;
    private final Boolean includeParameterSpec;

    private GetBlueprintRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.includeBlueprint = builder.includeBlueprint;
        this.includeParameterSpec = builder.includeParameterSpec;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean includeBlueprint() {
        return this.includeBlueprint;
    }

    public final Boolean includeParameterSpec() {
        return this.includeParameterSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeBlueprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeParameterSpec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintRequest)) {
            return false;
        }
        GetBlueprintRequest other = (GetBlueprintRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.includeBlueprint(), other.includeBlueprint()) && Objects.equals(this.includeParameterSpec(), other.includeParameterSpec());
    }

    public final String toString() {
        return ToString.builder((String)"GetBlueprintRequest").add("Name", (Object)this.name()).add("IncludeBlueprint", (Object)this.includeBlueprint()).add("IncludeParameterSpec", (Object)this.includeParameterSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IncludeBlueprint": {
                return Optional.ofNullable(clazz.cast(this.includeBlueprint()));
            }
            case "IncludeParameterSpec": {
                return Optional.ofNullable(clazz.cast(this.includeParameterSpec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("IncludeBlueprint", INCLUDE_BLUEPRINT_FIELD);
        map.put("IncludeParameterSpec", INCLUDE_PARAMETER_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintRequest, T> g) {
        return obj -> g.apply((GetBlueprintRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private Boolean includeBlueprint;
        private Boolean includeParameterSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintRequest model) {
            super(model);
            this.name(model.name);
            this.includeBlueprint(model.includeBlueprint);
            this.includeParameterSpec(model.includeParameterSpec);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getIncludeBlueprint() {
            return this.includeBlueprint;
        }

        public final void setIncludeBlueprint(Boolean includeBlueprint) {
            this.includeBlueprint = includeBlueprint;
        }

        @Override
        public final Builder includeBlueprint(Boolean includeBlueprint) {
            this.includeBlueprint = includeBlueprint;
            return this;
        }

        public final Boolean getIncludeParameterSpec() {
            return this.includeParameterSpec;
        }

        public final void setIncludeParameterSpec(Boolean includeParameterSpec) {
            this.includeParameterSpec = includeParameterSpec;
        }

        @Override
        public final Builder includeParameterSpec(Boolean includeParameterSpec) {
            this.includeParameterSpec = includeParameterSpec;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlueprintRequest build() {
            return new GetBlueprintRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlueprintRequest> {
        public Builder name(String var1);

        public Builder includeBlueprint(Boolean var1);

        public Builder includeParameterSpec(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

