/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.StoredScriptId;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class Script
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Script> _DESERIALIZER = JsonpDeserializer.lazy(Script::buildScriptDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Script(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Script(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Script of(Function<Builder, ObjectBuilder<Script>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isInline() {
        return this._kind == Kind.Inline;
    }

    public InlineScript inline() {
        return (InlineScript)TaggedUnionUtils.get(this, Kind.Inline);
    }

    public boolean isStored() {
        return this._kind == Kind.Stored;
    }

    public StoredScriptId stored() {
        return (StoredScriptId)TaggedUnionUtils.get(this, Kind.Stored);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    private static JsonpDeserializer<Script> buildScriptDeserializer() {
        return new UnionDeserializer.Builder<Script, Kind, Object>(Script::new, false).addMember(Kind.Inline, InlineScript._DESERIALIZER).addMember(Kind.Stored, StoredScriptId._DESERIALIZER).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Script> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Script> inline(InlineScript v) {
            this._kind = Kind.Inline;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Script> inline(Function<InlineScript.Builder, ObjectBuilder<InlineScript>> fn) {
            return this.inline(fn.apply(new InlineScript.Builder()).build());
        }

        public ObjectBuilder<Script> stored(StoredScriptId v) {
            this._kind = Kind.Stored;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Script> stored(Function<StoredScriptId.Builder, ObjectBuilder<StoredScriptId>> fn) {
            return this.stored(fn.apply(new StoredScriptId.Builder()).build());
        }

        @Override
        public Script build() {
            this._checkSingleUse();
            return new Script(this);
        }
    }

    public static enum Kind {
        Inline,
        Stored;

    }
}

