/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ServiceName {
    SAGEMAKER("sagemaker", "sagemaker"),
    BEDROCK("bedrock", "bedrock");

    private final String userInputValue;
    private final String mlCommonsValue;
    private static final Map<String, ServiceName> SERVICE_NAME_MAP;

    private ServiceName(String userInputValue, String mlCommonsValue) {
        this.userInputValue = userInputValue;
        this.mlCommonsValue = mlCommonsValue;
    }

    @JsonValue
    public String getUserInputValue() {
        return this.userInputValue;
    }

    public String getMlCommonsValue() {
        return this.mlCommonsValue;
    }

    @JsonCreator
    public static ServiceName fromString(String value) {
        return SERVICE_NAME_MAP.get(value);
    }

    static {
        SERVICE_NAME_MAP = new HashMap<String, ServiceName>();
        for (ServiceName type : ServiceName.values()) {
            SERVICE_NAME_MAP.put(type.getUserInputValue(), type);
        }
    }
}

