/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otelmetrics;

import com.linecorp.armeria.server.ServiceRequestContext;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.opentelemetry.proto.collector.metrics.v1.MetricsServiceGrpc;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.dataprepper.exceptions.BufferWriteException;
import org.opensearch.dataprepper.exceptions.RequestCancelledException;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelMetricsGrpcService
extends MetricsServiceGrpc.MetricsServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(OTelMetricsGrpcService.class);
    public static final String REQUESTS_RECEIVED = "requestsReceived";
    public static final String SUCCESS_REQUESTS = "successRequests";
    public static final String RECORDS_CREATED = "recordsCreated";
    public static final String RECORDS_DROPPED = "recordsDropped";
    public static final String PAYLOAD_SIZE = "payloadSize";
    public static final String REQUEST_PROCESS_DURATION = "requestProcessDuration";
    private final int bufferWriteTimeoutInMillis;
    private final OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder;
    private final Buffer<Record<? extends Metric>> buffer;
    private final Counter requestsReceivedCounter;
    private final Counter successRequestsCounter;
    private final Counter recordsCreatedCounter;
    private final Counter recordsDroppedCounter;
    private final DistributionSummary payloadSizeSummary;
    private final Timer requestProcessDuration;
    private final Set<String> bufferPartitionKeys;

    public OTelMetricsGrpcService(int bufferWriteTimeoutInMillis, OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder, Buffer<Record<? extends Metric>> buffer, Set<String> bufferPartitionKeys, PluginMetrics pluginMetrics, String metricsPrefix) {
        this.bufferWriteTimeoutInMillis = bufferWriteTimeoutInMillis;
        this.buffer = buffer;
        this.bufferPartitionKeys = bufferPartitionKeys;
        if (metricsPrefix != null) {
            this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED, metricsPrefix);
            this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS, metricsPrefix);
            this.recordsCreatedCounter = pluginMetrics.counter(RECORDS_CREATED, metricsPrefix);
            this.recordsDroppedCounter = pluginMetrics.counter(RECORDS_DROPPED, metricsPrefix);
            this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE, metricsPrefix);
            this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION, metricsPrefix);
        } else {
            this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED);
            this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS);
            this.recordsCreatedCounter = pluginMetrics.counter(RECORDS_CREATED);
            this.recordsDroppedCounter = pluginMetrics.counter(RECORDS_DROPPED);
            this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE);
            this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION);
        }
        this.oTelProtoDecoder = oTelProtoDecoder;
    }

    public void export(ExportMetricsServiceRequest request, StreamObserver<ExportMetricsServiceResponse> responseObserver) {
        this.requestsReceivedCounter.increment();
        this.payloadSizeSummary.record((double)request.getSerializedSize());
        if (ServiceRequestContext.current().isTimedOut()) {
            return;
        }
        if (Context.current().isCancelled()) {
            throw new RequestCancelledException("Cancelled by client");
        }
        this.requestProcessDuration.record(() -> this.processRequest(request, responseObserver));
    }

    private void processRequest(ExportMetricsServiceRequest request, StreamObserver<ExportMetricsServiceResponse> responseObserver) {
        try {
            if (this.buffer.isByteBuffer()) {
                if (this.bufferPartitionKeys != null && !this.bufferPartitionKeys.isEmpty()) {
                    Map requestsMap = this.oTelProtoDecoder.splitExportMetricsServiceRequestByKeys(request, this.bufferPartitionKeys);
                    for (Map.Entry entry : requestsMap.entrySet()) {
                        this.buffer.writeBytes(((ExportMetricsServiceRequest)entry.getValue()).toByteArray(), (String)entry.getKey(), this.bufferWriteTimeoutInMillis);
                    }
                } else {
                    this.buffer.writeBytes(request.toByteArray(), null, this.bufferWriteTimeoutInMillis);
                }
            } else {
                AtomicInteger droppedCounter = new AtomicInteger(0);
                Collection metrics = this.oTelProtoDecoder.parseExportMetricsServiceRequest(request, droppedCounter, Integer.valueOf(10), Instant.now(), true, true, true);
                this.recordsDroppedCounter.increment((double)droppedCounter.get());
                this.recordsCreatedCounter.increment((double)metrics.size());
                this.buffer.writeAll(metrics, this.bufferWriteTimeoutInMillis);
            }
        }
        catch (Exception e) {
            if (ServiceRequestContext.current().isTimedOut()) {
                LOG.warn("Exception writing to buffer but request already timed out.", (Throwable)e);
                return;
            }
            LOG.error("Failed to write the request of size {} due to:", (Object)request.toString().length(), (Object)e);
            throw new BufferWriteException(e.getMessage(), (Throwable)e);
        }
        if (ServiceRequestContext.current().isTimedOut()) {
            LOG.warn("Buffer write completed successfully but request already timed out.");
            return;
        }
        this.successRequestsCounter.increment();
        responseObserver.onNext((Object)ExportMetricsServiceResponse.newBuilder().build());
        responseObserver.onCompleted();
    }
}

