/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import com.arpnetworking.metrics.prometheus.Remote;
import com.arpnetworking.metrics.prometheus.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.common.sink.DefaultSinkFlushResult;
import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.common.sink.SinkFlushContext;
import org.opensearch.dataprepper.common.sink.SinkFlushResult;
import org.opensearch.dataprepper.common.sink.SinkFlushableBuffer;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusHttpSender;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusPushResult;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferEntry;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkFlushContext;

public class PrometheusSinkFlushableBuffer
implements SinkFlushableBuffer {
    List<SinkBufferEntry> buffer;
    final PrometheusSinkFlushContext sinkFlushContext;
    final SinkMetrics sinkMetrics;

    public PrometheusSinkFlushableBuffer(List<SinkBufferEntry> buffer, SinkMetrics sinkMetrics, SinkFlushContext sinkFlushContext) {
        this.buffer = buffer;
        this.sinkMetrics = sinkMetrics;
        this.sinkFlushContext = (PrometheusSinkFlushContext)sinkFlushContext;
    }

    public SinkFlushResult flush() {
        if (this.buffer.isEmpty()) {
            return null;
        }
        PrometheusHttpSender httpSender = this.sinkFlushContext.getHttpSender();
        Remote.WriteRequest.Builder writeRequestBuilder = Remote.WriteRequest.newBuilder();
        ArrayList<Types.TimeSeries> allTimeSeries = new ArrayList<Types.TimeSeries>(this.buffer.size() * 2);
        ArrayList<Event> events = new ArrayList<Event>(this.buffer.size());
        for (SinkBufferEntry sinkBufferEntry : this.buffer) {
            PrometheusSinkBufferEntry bufferEntry = (PrometheusSinkBufferEntry)sinkBufferEntry;
            allTimeSeries.addAll(bufferEntry.getTimeSeries().getTimeSeriesList());
            events.add(bufferEntry.getEvent());
        }
        this.buffer.clear();
        writeRequestBuilder.addAllTimeseries(allTimeSeries);
        Remote.WriteRequest request = writeRequestBuilder.build();
        byte[] bytes = request.toByteArray();
        PrometheusPushResult result = httpSender.pushToEndpoint(bytes);
        if (!result.isSuccess()) {
            this.sinkMetrics.incrementRequestsFailedCounter(1);
            this.sinkMetrics.incrementEventsFailedCounter(events.size());
            return new DefaultSinkFlushResult(events, result.getStatusCode(), null);
        }
        this.sinkMetrics.incrementRequestsSuccessCounter(1);
        this.sinkMetrics.incrementEventsSuccessCounter(events.size());
        return null;
    }

    public List<Event> getEvents() {
        return this.buffer.stream().map(SinkBufferEntry::getEvent).collect(Collectors.toList());
    }
}

