/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus;

import com.google.common.annotations.VisibleForTesting;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryRuleWithContent;
import com.linecorp.armeria.client.retry.RetryRuleWithContentBuilder;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.client.retry.RetryingClientBuilder;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.codec.CompressionEngine;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusPushResult;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusSigV4Signer;
import org.opensearch.dataprepper.plugins.sink.prometheus.configuration.PrometheusSinkConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;

public class PrometheusHttpSender {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusHttpSender.class);
    private static final int DEFAULT_MAX_REQUEST_SIZE = 0x100000;
    private static final Set<Integer> RETRYABLE_STATUS_CODES = Set.of(Integer.valueOf(429), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504));
    private static final int BACKOFF_INITIAL_DELAY_MS = 100;
    private static final int BACKOFF_MAX_DELAY_MS = 10000;
    private static final double BACKOFF_DEFAULT_JITTER = 0.2;
    private final PrometheusSigV4Signer signer;
    private final WebClient webClient;
    private final SinkMetrics sinkMetrics;
    private final long connectionTimeoutMillis;
    private final long idleTimeoutMillis;
    private final CompressionEngine compressionEngine;
    private final PrometheusSinkConfiguration config;

    public PrometheusHttpSender(@Nonnull AwsCredentialsSupplier awsCredentialsSupplier, @Nonnull PrometheusSinkConfiguration config, @Nonnull SinkMetrics sinkMetrics) {
        this(awsCredentialsSupplier, PrometheusHttpSender.buildWebClient(config), config, sinkMetrics);
    }

    @VisibleForTesting
    public PrometheusHttpSender(@Nonnull AwsCredentialsSupplier awsCredentialsSupplier, @Nonnull WebClient webClient, @Nonnull PrometheusSinkConfiguration config, @Nonnull SinkMetrics sinkMetrics) {
        this.signer = config.getAwsConfig() != null ? new PrometheusSigV4Signer(awsCredentialsSupplier, config) : null;
        this.webClient = webClient;
        this.compressionEngine = config.getEncoding().getCompressionEngine();
        this.sinkMetrics = sinkMetrics;
        this.config = config;
        this.connectionTimeoutMillis = config.getConnectionTimeout().toMillis();
        this.idleTimeoutMillis = config.getIdleTimeout().toMillis();
    }

    private static WebClient buildWebClient(PrometheusSinkConfiguration config) {
        RetryRuleWithContent retryRule = ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatus((ctx, status) -> RETRYABLE_STATUS_CODES.contains(status.code()))).thenBackoff(Backoff.exponential((long)100L, (long)10000L).withJitter(0.2));
        long estimatedContentLimit = Math.max(1, 0x100000) * (config.getMaxRetries() + 1);
        int safeContentLimit = (int)Math.min(estimatedContentLimit, Integer.MAX_VALUE);
        RetryingClientBuilder retryingClientBuilder = RetryingClient.builder((RetryRuleWithContent)retryRule, (int)safeContentLimit).maxTotalAttempts(config.getMaxRetries() + 1);
        return WebClient.builder().factory(ClientFactory.builder().connectTimeout(config.getConnectionTimeout()).idleTimeout(config.getIdleTimeout()).build()).decorator(retryingClientBuilder.newDecorator()).responseTimeoutMillis(config.getRequestTimeout().toMillis()).maxResponseLength((long)safeContentLimit).options(ClientOptions.builder().build()).build();
    }

    public PrometheusPushResult pushToEndpoint(byte[] payload) {
        PrometheusPushResult result;
        try {
            byte[] compressedBufferData = this.compressionEngine.compress(payload);
            HttpRequest request = this.buildHttpRequest(compressedBufferData);
            if (request == null) {
                return new PrometheusPushResult(false, 0);
            }
            long startTime = System.currentTimeMillis();
            result = (PrometheusPushResult)((CompletableFuture)((CompletableFuture)this.webClient.execute(request).aggregate().thenApply(response -> {
                long latency = System.currentTimeMillis() - startTime;
                this.sinkMetrics.recordRequestSize((double)compressedBufferData.length);
                LOG.debug("Response received in {}ms. Status: {}", (Object)latency, (Object)response.status());
                int statusCode = response.status().code();
                byte[] responseBytes = response.content().array();
                return new PrometheusPushResult(this.handleResponse(statusCode, responseBytes), statusCode);
            })).exceptionally(throwable -> {
                LOG.error(DataPrepperMarkers.NOISY, "Request failed", throwable);
                return new PrometheusPushResult(false, 0);
            })).join();
        }
        catch (Exception e) {
            LOG.error(DataPrepperMarkers.NOISY, "Failed to execute request", (Throwable)e);
            result = new PrometheusPushResult(false, 0);
        }
        return result;
    }

    private SdkHttpFullRequest createSdkHttpRequest(String url, @Nonnull byte[] payload) {
        return SdkHttpFullRequest.builder().method(SdkHttpMethod.POST).uri(URI.create(url)).putHeader("Content-Encoding", this.config.getEncoding().toString()).putHeader("Content-Type", this.config.getContentType()).putHeader("X-Prometheus-Remote-Write-Version", this.config.getRemoteWriteVersion()).putHeader("x-amz-content-sha256", "required").contentStreamProvider(() -> SdkBytes.fromByteArray((byte[])payload).asInputStream()).build();
    }

    private HttpRequest buildHttpRequest(byte[] payload) {
        SdkHttpFullRequest sdkHttpRequest = this.createSdkHttpRequest(this.config.getUrl(), payload);
        if (this.signer != null && (sdkHttpRequest = this.signer.signRequest(sdkHttpRequest)) == null) {
            return null;
        }
        RequestHeadersBuilder headersBuilder = RequestHeaders.builder().method(HttpMethod.POST).scheme(sdkHttpRequest.getUri().getScheme()).path(sdkHttpRequest.getUri().getRawPath()).authority(sdkHttpRequest.getUri().getAuthority());
        sdkHttpRequest.headers().forEach((k, vList) -> vList.forEach(v -> {
            LOG.debug("Adding header [{}] = [{}]", k, v);
            headersBuilder.add((CharSequence)k, v);
        }));
        HttpRequest request = HttpRequest.of((RequestHeaders)headersBuilder.build(), (HttpData)HttpData.wrap((byte[])payload));
        LOG.debug("Final request URI: {}", (Object)request.uri());
        LOG.debug("Final request headers: {}", (Object)request.headers());
        return request;
    }

    private boolean handleResponse(int statusCode, byte[] responseBytes) {
        if (statusCode >= 200 && statusCode < 300) {
            return true;
        }
        String responseBody = responseBytes != null ? new String(responseBytes, StandardCharsets.UTF_8) : "<no body>";
        LOG.error(DataPrepperMarkers.NOISY, "Non-successful Prometheus server response. Status: {}, Response: {}", (Object)statusCode, (Object)responseBody);
        return false;
    }
}

