/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.DataSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSourceReferenceRequest
extends BaseReferenceRequest<DataSource> {
    public DataSourceReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSource.class);
    }

    @Nonnull
    public DataSourceReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DataSourceReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<DataSource> putAsync(@Nonnull DataSource srcDataSource) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/cases/{id}/ediscoveryCases/{id}/searches/{id}/additionalSources/" + srcDataSource.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public DataSource put(@Nonnull DataSource srcDataSource) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/cases/{id}/ediscoveryCases/{id}/searches/{id}/additionalSources/" + srcDataSource.id));
        return (DataSource)this.send(HttpMethod.PUT, payload);
    }
}

