/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.util.SinkPropertyConfigurer;

public class RestUtils {
    private final RestService restService;
    private static String method = "POST";
    private static String CONTENT_TYPE_KEY = "Content-Type";
    private static String CONTENT_TYPE_JSON_VALUE = "application/vnd.schemaregistry.v1+json";
    private final SchemaConfig schemaConfig;

    public RestUtils(SchemaConfig schemaConfig) {
        this.schemaConfig = schemaConfig;
        this.restService = this.getRestService(schemaConfig.getRegistryURL());
    }

    @NotNull
    private RestService getRestService(String url) {
        RestService restService = new RestService(url);
        restService.configure(this.getSchemaProperties());
        return restService;
    }

    @NotNull
    private Map<String, String> getRequestProperties() {
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put(CONTENT_TYPE_KEY, CONTENT_TYPE_JSON_VALUE);
        return requestProperties;
    }

    @NotNull
    private Map getSchemaProperties() {
        Properties schemaProps = new Properties();
        SinkPropertyConfigurer.setSchemaCredentialsConfig(this.schemaConfig, schemaProps);
        Properties propertiesMap = schemaProps;
        return propertiesMap;
    }

    public <T> T getHttpResponse(String schemaString, String path, TypeReference<T> responseFormat) throws IOException, RestClientException {
        return (T)this.restService.httpRequest(path, method, schemaString.getBytes(StandardCharsets.UTF_8), this.getRequestProperties(), responseFormat);
    }
}

