/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.opensearch.dataprepper.model.metric.Exemplar;
import org.opensearch.dataprepper.model.metric.JacksonHistogram;
import org.opensearch.dataprepper.model.trace.Span;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCommonUtils;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateProcessor;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.HistogramAggregateActionConfig;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.OutputFormat;
import org.opensearch.dataprepper.plugins.processor.otelmetrics.OTelMetricsProtoHelper;

@DataPrepperPlugin(name="histogram", pluginType=AggregateAction.class, pluginConfigurationType=HistogramAggregateActionConfig.class)
public class HistogramAggregateAction
implements AggregateAction {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String EVENT_TYPE = "event";
    private final String countKey;
    private final String bucketCountsKey;
    private final String bucketsKey;
    private final String startTimeKey;
    private final String endTimeKey;
    private final OutputFormat outputFormat;
    private final String sumKey;
    private final String maxKey;
    private final String minKey;
    private final String durationKey;
    private final String key;
    private final String units;
    private final boolean recordMinMax;
    private Event minEvent;
    private Event maxEvent;
    private double minValue;
    private double maxValue;
    private final String metricName;
    private double[] buckets;

    @DataPrepperPluginConstructor
    public HistogramAggregateAction(HistogramAggregateActionConfig histogramAggregateActionConfig) {
        this.key = histogramAggregateActionConfig.getKey();
        List<Number> bucketList = histogramAggregateActionConfig.getBuckets();
        this.buckets = new double[bucketList.size() + 2];
        int bucketIdx = 0;
        this.metricName = histogramAggregateActionConfig.getMetricName();
        this.buckets[bucketIdx++] = -3.4028234663852886E38;
        for (int i = 0; i < bucketList.size(); ++i) {
            this.buckets[bucketIdx++] = this.convertToDouble(bucketList.get(i));
        }
        this.buckets[bucketIdx] = 3.4028234663852886E38;
        Arrays.sort(this.buckets);
        this.sumKey = histogramAggregateActionConfig.getSumKey();
        this.minKey = histogramAggregateActionConfig.getMinKey();
        this.maxKey = histogramAggregateActionConfig.getMaxKey();
        this.countKey = histogramAggregateActionConfig.getCountKey();
        this.bucketsKey = histogramAggregateActionConfig.getBucketsKey();
        this.bucketCountsKey = histogramAggregateActionConfig.getBucketCountsKey();
        this.startTimeKey = histogramAggregateActionConfig.getStartTimeKey();
        this.endTimeKey = histogramAggregateActionConfig.getEndTimeKey();
        this.durationKey = histogramAggregateActionConfig.getDurationKey();
        this.outputFormat = histogramAggregateActionConfig.getOutputFormat();
        this.units = histogramAggregateActionConfig.getUnits();
        this.recordMinMax = histogramAggregateActionConfig.getRecordMinMax();
    }

    private double convertToDouble(Number value) {
        double doubleValue = value instanceof Long ? (double)value.longValue() : (value instanceof Integer ? (double)value.intValue() : (value instanceof Short ? (double)value.shortValue() : (value instanceof Byte ? (double)value.byteValue() : (value instanceof Float ? (double)value.floatValue() : value.doubleValue()))));
        return doubleValue;
    }

    public Exemplar createExemplar(String id, Event event, double value) {
        long curTimeNanos = AggregateProcessor.getTimeNanos(Instant.now());
        Map attributes = event.toMap();
        if (Objects.nonNull(id)) {
            attributes.put("exemplarId", id);
        }
        String spanId = null;
        String traceId = null;
        if (event instanceof Span) {
            Span span = (Span)event;
            spanId = span.getSpanId();
            traceId = span.getTraceId();
        }
        return new DefaultExemplar(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)curTimeNanos), Double.valueOf(value), spanId, traceId, attributes);
    }

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        Instant eventTime;
        GroupState groupState = aggregateActionInput.getGroupState();
        Number value = (Number)event.get(this.key, Number.class);
        if (value == null) {
            return AggregateActionResponse.nullEventResponse();
        }
        double doubleValue = this.convertToDouble(value);
        int idx = Arrays.binarySearch(this.buckets, doubleValue);
        if (idx < 0) {
            idx = -idx - 2;
        }
        Instant eventStartTime = eventTime = Instant.now();
        Instant eventEndTime = eventTime;
        Object startTime = event.get(this.startTimeKey, Object.class);
        Object endTime = event.get(this.endTimeKey, Object.class);
        if (startTime != null) {
            eventStartTime = AggregateProcessor.convertObjectToInstant(startTime);
        }
        if (endTime != null) {
            eventEndTime = AggregateProcessor.convertObjectToInstant(endTime);
        }
        if (groupState.get(this.bucketCountsKey) == null) {
            groupState.put(this.startTimeKey, eventStartTime);
            groupState.put(this.endTimeKey, eventEndTime);
            Object[] bucketCountsList = new Long[this.buckets.length - 1];
            Arrays.fill(bucketCountsList, (Object)0L);
            Object[] objectArray = bucketCountsList;
            int n = idx;
            Object object = objectArray[n];
            objectArray[n] = (Long)objectArray[n] + 1L;
            Long l = objectArray[n];
            groupState.putAll(aggregateActionInput.getIdentificationKeys());
            groupState.put(this.sumKey, doubleValue);
            groupState.put(this.countKey, 1);
            groupState.put(this.bucketCountsKey, bucketCountsList);
            if (this.recordMinMax) {
                groupState.put(this.minKey, doubleValue);
                groupState.put(this.maxKey, doubleValue);
                this.minEvent = event;
                this.maxEvent = event;
                this.minValue = doubleValue;
                this.maxValue = doubleValue;
            }
        } else {
            Long[] bucketCountsList;
            Integer v = (Integer)groupState.get(this.countKey) + 1;
            groupState.put(this.countKey, v);
            double sum = (Double)groupState.get(this.sumKey);
            groupState.put(this.sumKey, sum + doubleValue);
            Long[] longArray = bucketCountsList = (Long[])groupState.get(this.bucketCountsKey);
            int n = idx;
            Long l = longArray[n];
            Long l2 = longArray[n] = Long.valueOf(longArray[n] + 1L);
            if (this.recordMinMax) {
                double max;
                double min = (Double)groupState.get(this.minKey);
                if (doubleValue < min) {
                    groupState.put(this.minKey, doubleValue);
                    this.minEvent = event;
                    this.minValue = doubleValue;
                }
                if (doubleValue > (max = ((Double)groupState.get(this.maxKey)).doubleValue())) {
                    groupState.put(this.maxKey, doubleValue);
                    this.maxEvent = event;
                    this.maxValue = doubleValue;
                }
            }
            Instant groupStartTime = (Instant)groupState.get(this.startTimeKey);
            Instant groupEndTime = (Instant)groupState.get(this.endTimeKey);
            if (eventStartTime.isBefore(groupStartTime)) {
                groupState.put(this.startTimeKey, eventStartTime);
            }
            if (eventEndTime.isAfter(groupEndTime)) {
                groupState.put(this.endTimeKey, eventEndTime);
            }
        }
        return AggregateActionResponse.nullEventResponse();
    }

    @Override
    public AggregateActionOutput concludeGroup(AggregateActionInput aggregateActionInput) {
        JacksonEvent event;
        GroupState groupState = aggregateActionInput.getGroupState();
        if (groupState.isEmpty()) {
            return null;
        }
        Instant startTime = (Instant)groupState.get(this.startTimeKey);
        Instant endTime = (Instant)groupState.get(this.endTimeKey);
        long startTimeNanos = AggregateProcessor.getTimeNanos(startTime);
        long endTimeNanos = AggregateProcessor.getTimeNanos(endTime);
        String histogramKey = this.metricName + "_key";
        ArrayList<Exemplar> exemplarList = new ArrayList<Exemplar>();
        exemplarList.add(this.createExemplar("min", this.minEvent, this.minValue));
        exemplarList.add(this.createExemplar("max", this.maxEvent, this.maxValue));
        if (this.outputFormat == OutputFormat.RAW) {
            groupState.put(histogramKey, this.key);
            groupState.put(this.durationKey, endTimeNanos - startTimeNanos);
            groupState.put(this.bucketsKey, Arrays.copyOfRange(this.buckets, 1, this.buckets.length - 1));
            groupState.put(this.startTimeKey, startTime.atZone(ZoneId.of(ZoneId.systemDefault().toString())).format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
            event = JacksonEvent.builder().withEventType(EVENT_TYPE).withData((Object)groupState).withEventHandle(aggregateActionInput.getEventHandle()).build();
        } else {
            ArrayList<Double> explicitBoundsList = new ArrayList<Double>();
            List<Long> bucketCounts = Arrays.asList((Long[])groupState.get(this.bucketCountsKey));
            for (int i = 1; i < this.buckets.length - 1; ++i) {
                explicitBoundsList.add(this.buckets[i]);
            }
            List buckets = OTelMetricsProtoHelper.createBuckets(bucketCounts, explicitBoundsList);
            HashMap<Object, Object> attr = new HashMap<Object, Object>();
            aggregateActionInput.getIdentificationKeys().forEach((k, v) -> attr.put((String)k, v));
            attr.put(histogramKey, this.key);
            attr.put(this.durationKey, endTimeNanos - startTimeNanos);
            double sum = (Double)groupState.get(this.sumKey);
            Double max = (Double)groupState.get(this.maxKey);
            Double min = (Double)groupState.get(this.minKey);
            Integer count = (Integer)groupState.get(this.countKey);
            String description = String.format("Histogram of %s in the events", this.key);
            JacksonHistogram histogram = ((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)((JacksonHistogram.Builder)JacksonHistogram.builder().withName(this.metricName)).withDescription(description)).withTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)endTimeNanos))).withStartTime(OTelProtoCommonUtils.convertUnixNanosToISO8601((long)startTimeNanos))).withUnit(this.units)).withSum(sum).withMin(min).withMax(max).withCount((long)count.intValue()).withBucketCount(this.buckets.length - 1).withExplicitBoundsCount(this.buckets.length - 2).withAggregationTemporality(AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA.name()).withBuckets(buckets).withBucketCountsList(bucketCounts).withExplicitBoundsList(explicitBoundsList).withExemplars(exemplarList)).withAttributes(attr)).withEventHandle(aggregateActionInput.getEventHandle())).build(false);
            event = histogram;
        }
        return new AggregateActionOutput(List.of(event));
    }
}

