/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.coordination;

import java.util.function.Function;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.DataQueryPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.ExportPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.GlobalState;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.S3FolderPartition;
import org.opensearch.dataprepper.plugins.mongo.coordination.partition.StreamPartition;

public class PartitionFactory
implements Function<SourcePartitionStoreItem, EnhancedSourcePartition> {
    @Override
    public EnhancedSourcePartition apply(SourcePartitionStoreItem partitionStoreItem) {
        String partitionType;
        String sourceIdentifier = partitionStoreItem.getSourceIdentifier();
        switch (partitionType = sourceIdentifier.substring(sourceIdentifier.lastIndexOf(124) + 1)) {
            case "EXPORT": {
                return new ExportPartition(partitionStoreItem);
            }
            case "DATA_QUERY": {
                return new DataQueryPartition(partitionStoreItem);
            }
            case "STREAM": {
                return new StreamPartition(partitionStoreItem);
            }
            case "LEADER": {
                return new LeaderPartition(partitionStoreItem);
            }
            case "S3_FOLDER": {
                return new S3FolderPartition(partitionStoreItem);
            }
        }
        return new GlobalState(partitionStoreItem);
    }
}

