/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.AllocationResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AllocationRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<String> nodeId;
    public static final Endpoint<AllocationRequest, AllocationResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AllocationRequest, AllocationResponse>("es/cat.allocation", request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/allocation");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/allocation");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, AllocationResponse._DESERIALIZER);

    private AllocationRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
    }

    public static AllocationRequest of(Function<Builder, ObjectBuilder<AllocationRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AllocationRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<String> nodeId;

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Override
        public AllocationRequest build() {
            this._checkSingleUse();
            return new AllocationRequest(this);
        }
    }
}

