/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.Map;
import java.util.function.BiPredicate;
import org.opensearch.dataprepper.expression.BinaryOperator;

class GenericEqualOperator
extends BinaryOperator<Boolean> {
    private final Map<Class<?>, Map<Class<?>, BiPredicate<Object, Object>>> equalStrategy;

    public GenericEqualOperator(int symbol, int shouldEvaluateRuleIndex, Map<Class<?>, Map<Class<?>, BiPredicate<Object, Object>>> equalStrategy) {
        super(symbol, shouldEvaluateRuleIndex);
        this.equalStrategy = equalStrategy;
    }

    @Override
    public boolean isBooleanOperator() {
        return true;
    }

    @Override
    protected Boolean checkedEvaluate(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        if (this.hasStrategyMatching(lhs, rhs)) {
            return this.equalStrategy.get(lhs.getClass()).get(rhs.getClass()).test(lhs, rhs);
        }
        return lhs.equals(rhs);
    }

    private boolean hasStrategyMatching(Object leftOperand, Object rightOperand) {
        return this.equalStrategy.containsKey(leftOperand.getClass()) && this.equalStrategy.get(leftOperand.getClass()).containsKey(rightOperand.getClass());
    }
}

