/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.protobuf.Message;
import java.io.IOException;
import org.curioswitch.common.protobuf.json.JsonGeneratorWrapper;
import org.curioswitch.common.protobuf.json.JsonParserWrapper;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

public final class MessageMarshallerModule
extends SimpleModule {
    private static final long serialVersionUID = -7559578444655954044L;

    public static Module of(MessageMarshaller marshaller) {
        return new MessageMarshallerModule(marshaller);
    }

    private MessageMarshallerModule(MessageMarshaller marshaller) {
        for (Message message : marshaller.registeredPrototypes()) {
            this.addDeserializer(message.getClass(), (JsonDeserializer)new MessageDeserializer<Message>(message, marshaller));
            this.addSerializer((JsonSerializer)new MessageSerializer<Message>(message, marshaller));
        }
    }

    private static class MessageDeserializer<T extends Message>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = 2347902651812283460L;
        private final transient T prototype;
        private final transient MessageMarshaller marshaller;

        MessageDeserializer(T prototype, MessageMarshaller marshaller) {
            super(prototype.getClass());
            this.prototype = prototype;
            this.marshaller = marshaller;
        }

        public T deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            JsonParserWrapper wrapped = new JsonParserWrapper(parser, (p, clz) -> {
                JsonDeserializer deserializer;
                try {
                    deserializer = ctxt.findNonContextualValueDeserializer(ctxt.constructType(clz));
                }
                catch (JsonMappingException e) {
                    return JsonParserWrapper.NOT_DESERIALIZED;
                }
                if (deserializer == null) {
                    return JsonParserWrapper.NOT_DESERIALIZED;
                }
                return deserializer.deserialize(p, ctxt);
            });
            Message.Builder builder = this.prototype.newBuilderForType();
            this.marshaller.mergeValue((JsonParser)wrapped, builder);
            Message message = builder.build();
            return (T)message;
        }
    }

    private static class MessageSerializer<T extends Message>
    extends StdSerializer<T> {
        private static final long serialVersionUID = 7592254532224523930L;
        private final MessageMarshaller marshaller;

        MessageSerializer(T prototype, MessageMarshaller marshaller) {
            super(prototype.getClass(), true);
            this.marshaller = marshaller;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            JsonGeneratorWrapper wrapped = new JsonGeneratorWrapper(gen, (obj, g) -> {
                JsonSerializer serializer;
                try {
                    serializer = provider.findValueSerializer(obj.getClass());
                }
                catch (JsonMappingException e) {
                    return false;
                }
                if (serializer == null) {
                    return false;
                }
                serializer.serialize(obj, g, provider);
                return true;
            });
            this.marshaller.writeValue(value, (JsonGenerator)wrapped);
        }
    }
}

