/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.opensearch.dataprepper.model.sink.SinkContext;

public class OutputCodecContext {
    private final String tagsTargetKey;
    private final List<String> includeKeys;
    private final List<String> excludeKeys;
    private final Predicate<String> inclusionPredicate;

    public OutputCodecContext() {
        this(null, Collections.emptyList(), Collections.emptyList());
    }

    public OutputCodecContext(String tagsTargetKey, List<String> includeKeys, List<String> excludeKeys) {
        this.tagsTargetKey = tagsTargetKey;
        this.includeKeys = includeKeys;
        this.excludeKeys = excludeKeys;
        this.inclusionPredicate = includeKeys != null && !includeKeys.isEmpty() ? k -> includeKeys.contains(k) : (excludeKeys != null && !excludeKeys.isEmpty() ? k -> !excludeKeys.contains(k) : k -> true);
    }

    public static OutputCodecContext fromSinkContext(SinkContext sinkContext) {
        if (sinkContext == null) {
            return new OutputCodecContext();
        }
        return new OutputCodecContext(sinkContext.getTagsTargetKey(), sinkContext.getIncludeKeys(), sinkContext.getExcludeKeys());
    }

    public String getTagsTargetKey() {
        return this.tagsTargetKey;
    }

    public List<String> getIncludeKeys() {
        return this.includeKeys;
    }

    public List<String> getExcludeKeys() {
        return this.excludeKeys;
    }

    public boolean shouldIncludeKey(String key) {
        return this.inclusionPredicate.test(key);
    }

    public boolean shouldNotIncludeKey(String key) {
        return !this.inclusionPredicate.test(key);
    }
}

