/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;

@Named
public class PluginConfigurationErrorHandler {
    static final String UNRECOGNIZED_PROPERTY_EXCEPTION_FORMAT = "Parameter \"%s\" for plugin \"%s\" does not exist. Available options include %s.";
    static final String JSON_MAPPING_EXCEPTION_FORMAT = "Parameter \"%s\" for plugin \"%s\" is invalid: %s";
    static final String GENERIC_PLUGIN_EXCEPTION_FORMAT = "Plugin \"%s\" is invalid: %s";
    static final Integer MIN_DISTANCE_TO_RECOMMEND_PROPERTY = 3;
    private final LevenshteinDistance levenshteinDistance;

    @Inject
    public PluginConfigurationErrorHandler(LevenshteinDistance levenshteinDistance) {
        this.levenshteinDistance = levenshteinDistance;
    }

    public RuntimeException handleException(PluginSetting pluginSetting, Exception e) {
        if (e.getCause() instanceof UnrecognizedPropertyException) {
            return this.handleUnrecognizedPropertyException((UnrecognizedPropertyException)e.getCause(), pluginSetting);
        }
        if (e.getCause() instanceof JsonMappingException) {
            return this.handleJsonMappingException((JsonMappingException)e.getCause(), pluginSetting);
        }
        return new InvalidPluginConfigurationException(String.format(GENERIC_PLUGIN_EXCEPTION_FORMAT, pluginSetting.getName(), e.getMessage()));
    }

    private RuntimeException handleJsonMappingException(JsonMappingException e, PluginSetting pluginSetting) {
        String parameterPath = this.getParameterPath(e.getPath());
        String errorMessage = String.format(JSON_MAPPING_EXCEPTION_FORMAT, parameterPath, pluginSetting.getName(), e.getOriginalMessage());
        return new InvalidPluginConfigurationException(errorMessage);
    }

    private RuntimeException handleUnrecognizedPropertyException(UnrecognizedPropertyException e, PluginSetting pluginSetting) {
        Object errorMessage = String.format(UNRECOGNIZED_PROPERTY_EXCEPTION_FORMAT, this.getParameterPath(e.getPath()), pluginSetting.getName(), e.getKnownPropertyIds());
        Optional<String> closestRecommendation = this.getClosestField(e);
        if (closestRecommendation.isPresent()) {
            errorMessage = (String)errorMessage + " Did you mean \"" + closestRecommendation.get() + "\"?";
        }
        return new InvalidPluginConfigurationException((String)errorMessage);
    }

    private Optional<String> getClosestField(UnrecognizedPropertyException e) {
        String closestMatch = null;
        int smallestDistance = Integer.MAX_VALUE;
        for (String field : e.getKnownPropertyIds().stream().map(Object::toString).collect(Collectors.toList())) {
            int distance = this.levenshteinDistance.apply((CharSequence)e.getPropertyName(), (CharSequence)field);
            if (distance >= smallestDistance) continue;
            smallestDistance = distance;
            closestMatch = field;
        }
        if (smallestDistance <= MIN_DISTANCE_TO_RECOMMEND_PROPERTY) {
            return Optional.ofNullable(closestMatch);
        }
        return Optional.empty();
    }

    private String getParameterPath(List<JsonMappingException.Reference> path) {
        return path.stream().map(JsonMappingException.Reference::getFieldName).collect(Collectors.joining("."));
    }
}

