/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

@Named
class PluginBeanFactoryProvider {
    private final GenericApplicationContext sharedPluginApplicationContext;
    private final GenericApplicationContext coreApplicationContext;

    @Inject
    PluginBeanFactoryProvider(GenericApplicationContext coreApplicationContext) {
        ApplicationContext publicContext = Objects.requireNonNull(coreApplicationContext.getParent());
        this.sharedPluginApplicationContext = new GenericApplicationContext(publicContext);
        this.coreApplicationContext = coreApplicationContext;
    }

    GenericApplicationContext getSharedPluginApplicationContext() {
        return this.sharedPluginApplicationContext;
    }

    GenericApplicationContext getCoreApplicationContext() {
        return this.coreApplicationContext;
    }

    public BeanFactory createPluginSpecificContext(Class[] markersToScan, Object configuration, PluginSetting pluginSetting) {
        AnnotationConfigApplicationContext isolatedPluginApplicationContext = new AnnotationConfigApplicationContext();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)isolatedPluginApplicationContext.getBeanFactory();
        if (markersToScan != null && markersToScan.length > 0) {
            if (configuration != null && !(configuration instanceof PluginSetting)) {
                beanFactory.registerSingleton(configuration.getClass().getName(), configuration);
            }
            if (pluginSetting != null) {
                beanFactory.registerSingleton(PluginMetrics.class.getName(), (Object)PluginMetrics.fromPluginSetting((PluginSetting)pluginSetting));
            }
            Arrays.stream(markersToScan).map(Class::getPackageName).forEach(xva$0 -> isolatedPluginApplicationContext.scan(new String[]{xva$0}));
            isolatedPluginApplicationContext.refresh();
        }
        isolatedPluginApplicationContext.setParent((ApplicationContext)this.sharedPluginApplicationContext);
        return beanFactory;
    }
}

