/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.configuration.PipelinesDataFlowModel;
import org.opensearch.dataprepper.plugin.ExtensionsConfiguration;

@Named
public class ExtensionPluginConfigurationResolver {
    private final Map<String, Object> combinedExtensionMap;
    private final Map<String, Object> dataPrepperConfigExtensionMap;

    @Inject
    public ExtensionPluginConfigurationResolver(ExtensionsConfiguration extensionsConfiguration, PipelinesDataFlowModel pipelinesDataFlowModel) {
        this.dataPrepperConfigExtensionMap = extensionsConfiguration.getPipelineExtensions() == null ? new HashMap<String, Object>() : new HashMap(extensionsConfiguration.getPipelineExtensions().getExtensionMap());
        this.combinedExtensionMap = new HashMap<String, Object>(this.dataPrepperConfigExtensionMap);
        if (pipelinesDataFlowModel.getPipelineExtensions() != null) {
            this.combinedExtensionMap.putAll(pipelinesDataFlowModel.getPipelineExtensions().getExtensionMap());
        }
    }

    public Map<String, Object> getDataPrepperConfigExtensionMap() {
        return Collections.unmodifiableMap(this.dataPrepperConfigExtensionMap);
    }

    public Map<String, Object> getCombinedExtensionMap() {
        return Collections.unmodifiableMap(this.combinedExtensionMap);
    }
}

