/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.grouping;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.BufferFactory;
import org.opensearch.dataprepper.plugins.sink.s3.codec.CodecFactory;
import org.opensearch.dataprepper.plugins.sink.s3.grouping.S3Group;
import org.opensearch.dataprepper.plugins.sink.s3.grouping.S3GroupIdentifier;
import org.opensearch.dataprepper.plugins.sink.s3.grouping.S3GroupIdentifierFactory;
import org.opensearch.dataprepper.plugins.sink.s3.ownership.BucketOwnerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;

public class S3GroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3GroupManager.class);
    private final Map<S3GroupIdentifier, S3Group> allGroups = Maps.newConcurrentMap();
    private final S3SinkConfig s3SinkConfig;
    private final S3GroupIdentifierFactory s3GroupIdentifierFactory;
    private final BufferFactory bufferFactory;
    private final CodecFactory codecFactory;
    private final S3AsyncClient s3Client;
    private final BucketOwnerProvider bucketOwnerProvider;
    private long totalGroupSize;

    public S3GroupManager(S3SinkConfig s3SinkConfig, S3GroupIdentifierFactory s3GroupIdentifierFactory, BufferFactory bufferFactory, CodecFactory codecFactory, S3AsyncClient s3Client, BucketOwnerProvider bucketOwnerProvider) {
        this.s3SinkConfig = s3SinkConfig;
        this.s3GroupIdentifierFactory = s3GroupIdentifierFactory;
        this.bufferFactory = bufferFactory;
        this.codecFactory = codecFactory;
        this.s3Client = s3Client;
        this.totalGroupSize = 0L;
        this.bucketOwnerProvider = bucketOwnerProvider;
    }

    public boolean hasNoGroups() {
        return this.allGroups.isEmpty();
    }

    public int getNumberOfGroups() {
        return this.allGroups.size();
    }

    public void removeGroup(S3Group s3Group) {
        this.allGroups.remove(s3Group.getS3GroupIdentifier());
    }

    public Collection<S3Group> getS3GroupEntries() {
        return this.allGroups.values();
    }

    public Collection<S3Group> getS3GroupsSortedBySize() {
        return this.allGroups.values().stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }

    public S3Group getOrCreateGroupForEvent(Event event) {
        S3GroupIdentifier s3GroupIdentifier = this.s3GroupIdentifierFactory.getS3GroupIdentifierForEvent(event);
        if (this.allGroups.containsKey(s3GroupIdentifier)) {
            return this.allGroups.get(s3GroupIdentifier);
        }
        Buffer bufferForNewGroup = this.bufferFactory.getBuffer(this.s3Client, s3GroupIdentifier::getFullBucketName, s3GroupIdentifier::getGroupIdentifierFullObjectKey, this.s3SinkConfig.getDefaultBucket(), s3GroupIdentifier::getMetadata, this.bucketOwnerProvider);
        OutputCodec outputCodec = this.codecFactory.provideCodec();
        S3Group s3Group = new S3Group(s3GroupIdentifier, bufferForNewGroup, outputCodec);
        this.allGroups.put(s3GroupIdentifier, s3Group);
        LOG.debug("Created a new S3 group. Total number of groups: {}", (Object)this.allGroups.size());
        return s3Group;
    }

    public long recalculateAndGetGroupSize() {
        long totalSize = 0L;
        for (S3Group s3Group : this.allGroups.values()) {
            totalSize += s3Group.getBuffer().getSize();
        }
        return totalSize;
    }
}

