/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.microsoft.graph.httpcore.middlewareoption.RetryOptions;
import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.logger.ILogger;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RetryHandler
implements Interceptor {
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.RETRY;
    private RetryOptions mRetryOption;
    private static final String RETRY_ATTEMPT_HEADER = "Retry-Attempt";
    private static final String RETRY_AFTER = "Retry-After";
    public static final int MSClientErrorCodeTooManyRequests = 429;
    public static final int MSClientErrorCodeServiceUnavailable = 503;
    public static final int MSClientErrorCodeGatewayTimeout = 504;
    private static final long DELAY_MILLISECONDS = 1000L;
    private final ILogger logger;

    public RetryHandler(@Nullable RetryOptions retryOption) {
        this(new DefaultLogger(), retryOption);
    }

    public RetryHandler(@Nonnull ILogger logger, @Nullable RetryOptions retryOption) {
        this.logger = Objects.requireNonNull(logger, "logger parameter cannot be null");
        this.mRetryOption = retryOption;
        if (this.mRetryOption == null) {
            this.mRetryOption = new RetryOptions();
        }
    }

    public RetryHandler() {
        this(null);
    }

    boolean retryRequest(Response response, int executionCount, Request request, RetryOptions retryOptions) {
        IShouldRetry shouldRetryCallback = null;
        if (retryOptions != null) {
            shouldRetryCallback = retryOptions.shouldRetry();
        }
        boolean shouldRetry = false;
        int statusCode = response.code();
        boolean bl = shouldRetry = retryOptions != null && executionCount <= retryOptions.maxRetries() && this.checkStatus(statusCode) && this.isBuffered(request) && shouldRetryCallback != null && shouldRetryCallback.shouldRetry(retryOptions.delay(), executionCount, request, response);
        if (shouldRetry) {
            long retryInterval = this.getRetryAfter(response, retryOptions.delay(), executionCount);
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.logError("error retrying the request", e);
            }
        }
        return shouldRetry;
    }

    long getRetryAfter(Response response, long delay, int executionCount) {
        String retryAfterHeader = response.header(RETRY_AFTER);
        double retryDelay = 3000.0;
        if (retryAfterHeader != null) {
            retryDelay = Long.parseLong(retryAfterHeader) * 1000L;
        } else {
            retryDelay = (Math.pow(2.0, executionCount) - 1.0) * 0.5;
            retryDelay = (executionCount < 2 ? (double)delay : retryDelay + (double)delay) + Math.random();
            retryDelay *= 1000.0;
        }
        return (long)Math.min(retryDelay, 180000.0);
    }

    boolean checkStatus(int statusCode) {
        return statusCode == 429 || statusCode == 503 || statusCode == 504;
    }

    boolean isBuffered(Request request) {
        String methodName = request.method();
        boolean isHTTPMethodPutPatchOrPost = methodName.equalsIgnoreCase("POST") || methodName.equalsIgnoreCase("PUT") || methodName.equalsIgnoreCase("PATCH");
        RequestBody requestBody = request.body();
        if (isHTTPMethodPutPatchOrPost && requestBody != null) {
            try {
                return requestBody.contentLength() != -1L;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        TelemetryOptions telemetryOptions = (TelemetryOptions)request.tag(TelemetryOptions.class);
        if (telemetryOptions == null) {
            telemetryOptions = new TelemetryOptions();
            request = request.newBuilder().tag(TelemetryOptions.class, (Object)telemetryOptions).build();
        }
        telemetryOptions.setFeatureUsage(2);
        Response response = chain.proceed(request);
        RetryOptions retryOption = (RetryOptions)request.tag(RetryOptions.class);
        retryOption = retryOption != null ? retryOption : this.mRetryOption;
        int executionCount = 1;
        while (this.retryRequest(response, executionCount, request, retryOption)) {
            request = request.newBuilder().addHeader(RETRY_ATTEMPT_HEADER, String.valueOf(executionCount)).build();
            ++executionCount;
            if (response != null) {
                ResponseBody body = response.body();
                if (body != null) {
                    body.close();
                }
                response.close();
            }
            response = chain.proceed(request);
        }
        return response;
    }
}

