/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.resync;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.converter.RecordConverter;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.ResyncPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.ResyncProgressState;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataTypeHelper;
import org.opensearch.dataprepper.plugins.source.rds.model.DbTableMetadata;
import org.opensearch.dataprepper.plugins.source.rds.schema.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLResyncWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLResyncWorker.class);
    private static final String QUERY_NULL_FORMAT_STRING = "SELECT * FROM %s WHERE %s IS NULL";
    private static final String QUERY_NOT_NULL_FORMAT_STRING = "SELECT * FROM %s WHERE %s='%s'";
    static final String DATA_PREPPER_EVENT_TYPE = "event";
    static final Duration BUFFER_TIMEOUT = Duration.ofSeconds(60L);
    static final int DEFAULT_BUFFER_BATCH_SIZE = 1000;
    private final ResyncPartition resyncPartition;
    private final RdsSourceConfig sourceConfig;
    private final QueryManager queryManager;
    private final Buffer<Record<Event>> buffer;
    private final RecordConverter recordConverter;
    private final AcknowledgementSet acknowledgementSet;
    private final DbTableMetadata dbTableMetadata;

    MySQLResyncWorker(ResyncPartition resyncPartition, RdsSourceConfig sourceConfig, QueryManager queryManager, Buffer<Record<Event>> buffer, RecordConverter recordConverter, AcknowledgementSet acknowledgementSet, DbTableMetadata dbTableMetadata) {
        this.resyncPartition = resyncPartition;
        this.sourceConfig = sourceConfig;
        this.queryManager = queryManager;
        this.buffer = buffer;
        this.recordConverter = recordConverter;
        this.acknowledgementSet = acknowledgementSet;
        this.dbTableMetadata = dbTableMetadata;
    }

    public static MySQLResyncWorker create(ResyncPartition resyncPartition, RdsSourceConfig sourceConfig, QueryManager queryManager, Buffer<Record<Event>> buffer, RecordConverter recordConverter, AcknowledgementSet acknowledgementSet, DbTableMetadata dbTableMetadata) {
        return new MySQLResyncWorker(resyncPartition, sourceConfig, queryManager, buffer, recordConverter, acknowledgementSet, dbTableMetadata);
    }

    @Override
    public void run() {
        ResyncPartition.PartitionKeyInfo partitionKeyInfo = this.resyncPartition.getPartitionKeyInfo();
        String database = partitionKeyInfo.getDatabase();
        String table = partitionKeyInfo.getTable();
        long eventTimestampMillis = partitionKeyInfo.getTimestamp();
        ResyncProgressState progressState = this.validateAndGetProgressState();
        String foreignKeyName = progressState.getForeignKeyName();
        Object updatedValue = progressState.getUpdatedValue();
        List<String> primaryKeys = progressState.getPrimaryKeys();
        List<Map<String, Object>> rows = this.executeQuery(database, table, foreignKeyName, updatedValue);
        this.processRows(rows, database, table, primaryKeys, eventTimestampMillis);
    }

    private void processRows(List<Map<String, Object>> rows, String database, String table, List<String> primaryKeys, long eventTimestampMillis) {
        BufferAccumulator bufferAccumulator = BufferAccumulator.create(this.buffer, (int)1000, (Duration)BUFFER_TIMEOUT);
        for (Map<String, Object> row : rows) {
            JacksonEvent dataPrepperEvent = JacksonEvent.builder().withEventType(DATA_PREPPER_EVENT_TYPE).withData(this.mapDataType(row, database + "." + table)).build();
            Event pipelineEvent = this.recordConverter.convert((Event)dataPrepperEvent, database, database, table, OpenSearchBulkActions.INDEX, primaryKeys, eventTimestampMillis, eventTimestampMillis, null);
            if (this.acknowledgementSet != null) {
                this.acknowledgementSet.add(pipelineEvent);
            }
            try {
                bufferAccumulator.add(new Record((Object)pipelineEvent));
            }
            catch (Exception e) {
                LOG.error("Failed to add event to buffer", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            bufferAccumulator.flush();
            if (this.acknowledgementSet != null) {
                this.acknowledgementSet.complete();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to flush buffer", (Throwable)e);
        }
    }

    private ResyncProgressState validateAndGetProgressState() {
        return this.resyncPartition.getProgressState().orElseThrow(() -> new IllegalStateException("ResyncPartition " + this.resyncPartition.getPartitionKey() + " doesn't contain progress state."));
    }

    private List<Map<String, Object>> executeQuery(String database, String table, String foreignKeyName, Object updatedValue) {
        LOG.debug("Will perform resync on table: {}.{}, with foreign key name: {}, and updated value: {}", new Object[]{database, table, foreignKeyName, updatedValue});
        String fullTableName = database + "." + table;
        String queryStatement = updatedValue == null ? String.format(QUERY_NULL_FORMAT_STRING, fullTableName, foreignKeyName) : String.format(QUERY_NOT_NULL_FORMAT_STRING, fullTableName, foreignKeyName, updatedValue);
        LOG.debug("Query statement: {}", (Object)queryStatement);
        List<Map<String, Object>> rows = this.queryManager.selectRows(queryStatement);
        LOG.debug("Found {} rows to resync", (Object)rows.size());
        return rows;
    }

    private Map<String, Object> mapDataType(Map<String, Object> rowData, String fullTableName) {
        Map<String, String> columnDataTypeMap = this.dbTableMetadata.getTableColumnDataTypeMap().get(fullTableName);
        HashMap<String, Object> rowDataAfterMapping = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rowData.entrySet()) {
            Object data = MySQLDataTypeHelper.getDataByColumnType(MySQLDataType.byDataType(columnDataTypeMap.get(entry.getKey())), entry.getKey(), entry.getValue(), null);
            rowDataAfterMapping.put(entry.getKey(), data);
        }
        return rowDataAfterMapping;
    }
}

