/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.stream.AbstractFixedStreamMessage;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.unsafe.PooledObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AggregatingStreamMessage<T>
extends AbstractFixedStreamMessage<T>
implements StreamWriter<T> {
    private final List<T> objs;
    private volatile boolean closed;

    public AggregatingStreamMessage(int initialCapacity) {
        this.objs = new ArrayList<T>(initialCapacity);
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isEmpty() {
        return this.objs.isEmpty();
    }

    @Override
    public boolean tryWrite(T o) {
        if (this.closed) {
            StreamMessageUtil.closeOrAbort(o);
            return false;
        }
        return this.objs.add(o);
    }

    @Override
    public CompletableFuture<Void> whenConsumed() {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void close(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.closed = true;
        this.abort(cause);
    }

    @Override
    T get(int index) {
        return this.objs.get(index);
    }

    @Override
    int size() {
        return this.objs.size();
    }

    @Override
    List<T> drainAll0(boolean withPooledObjects) {
        assert (this.closed) : this.getClass().getSimpleName() + " should be closed before publishing items";
        if (withPooledObjects) {
            for (T obj : this.objs) {
                PooledObjects.touch(obj);
            }
            return Collections.unmodifiableList(this.objs);
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(this.objs.size());
        for (T obj : this.objs) {
            builder.add(PooledObjects.copyAndClose(obj));
        }
        return builder.build();
    }
}

