/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMessage;
import com.linecorp.armeria.common.SplitHttpMessage;
import com.linecorp.armeria.common.stream.AggregationSupport;
import com.linecorp.armeria.common.stream.ByteStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.common.SplitHttpMessageSubscriber;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractSplitHttpMessage
extends AggregationSupport
implements SplitHttpMessage,
StreamMessage<HttpData> {
    private static final AtomicIntegerFieldUpdater<AbstractSplitHttpMessage> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractSplitHttpMessage.class, "subscribed");
    private volatile int subscribed;
    private final HttpMessage upstream;
    private final EventExecutor upstreamExecutor;
    private final SplitHttpMessageSubscriber bodySubscriber;

    AbstractSplitHttpMessage(HttpMessage upstream, EventExecutor upstreamExecutor, SplitHttpMessageSubscriber bodySubscriber) {
        this.upstream = Objects.requireNonNull(upstream, "upstream");
        this.upstreamExecutor = Objects.requireNonNull(upstreamExecutor, "upstreamExecutor");
        this.bodySubscriber = bodySubscriber;
        upstream.subscribe(bodySubscriber, this.upstreamExecutor, SubscriptionOption.values());
    }

    @Override
    public final ByteStreamMessage body() {
        return ByteStreamMessage.of(this);
    }

    @Override
    public final CompletableFuture<HttpHeaders> trailers() {
        return this.bodySubscriber.trailersFuture();
    }

    @Override
    public final boolean isOpen() {
        return this.upstream.isOpen();
    }

    @Override
    public final boolean isEmpty() {
        return !this.isOpen() && !this.bodySubscriber.wroteAny();
    }

    @Override
    public final long demand() {
        return this.upstream.demand();
    }

    @Override
    public final CompletableFuture<Void> whenComplete() {
        return this.upstream.whenComplete();
    }

    @Override
    public final void abort() {
        this.upstream.abort();
    }

    @Override
    public final void abort(Throwable cause) {
        this.upstream.abort(cause);
    }

    @Override
    public final EventExecutor defaultSubscriberExecutor() {
        return this.upstreamExecutor;
    }

    @Override
    public void subscribe(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            subscriber.onError((Throwable)new IllegalStateException("Only single subscriber is allowed!"));
            return;
        }
        if (this.upstreamExecutor.inEventLoop()) {
            this.bodySubscriber.initDownstream(subscriber, executor, options);
        } else {
            this.upstreamExecutor.execute(() -> this.bodySubscriber.initDownstream(subscriber, executor, options));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("subscribed", this.subscribed).add("upstream", this.upstream).add("upstreamExecutor", this.upstreamExecutor).add("bodySubscriber", this.bodySubscriber).toString();
    }
}

